/* Pico Technology ADC-11 楳 */
/* written by ä */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <machine/cpufunc.h>
#include "picoadc_reg.h"
#include "picoadc.h"

#define ADC_ADDR_WIDTH	4
#define ADC_DATA_WIDTH	10

#define WLOOP 2000

/* ADCѥ󤷤Ƴ */
/* adr: ץ󥿥ݡȤΥɥ쥹 */
unsigned int ADC_open(unsigned int adr)
{
  unsigned int a=0;
  a=ADC_POWER|ADC_CS;
  outb(adr+adc_control, a);

  return a;
}

/* ǥ(+5V on pin1)ONˤ */
/* state: ߤξ */
unsigned int ADC_set_dout(unsigned int adr, unsigned int state)
{
  state=ADC_DOUT|state;
  outb(adr+adc_control, state);

  return state;
}

/* ǥ(+5V on pin1)OFFˤ */
/* state: ߤξ */
unsigned int ADC_set_dclose(unsigned int adr, unsigned int state)
{
  state=(~ADC_DOUT)|state;
  outb(adr+adc_control, state);

  return state;
}

/* *CS */
/* ռƻȤɬ̵ */
/* a=0 high,  a=1 low */
unsigned int ADC_set_csel(unsigned int adr, unsigned int state, int a)
{
  if (a==0)
    state=state|ADC_CS;
  else
    state=state&(~ADC_CS);

  outb(adr+adc_control, state);
  usleep(1000);

  return state;
}

/* Ѵͤμ */
/* chnnl: ADC channel (1 - 11) */
int ADC_get_value(unsigned int adr, unsigned int chnnl, unsigned int state)
{
  unsigned int next_addr=0;
  int dummy=0, value=0, i=0;

  /* channel  1ͤɥ쥹 */
  if (chnnl<1) 
    chnnl=0;   /* ch1 */
  else if (chnnl>11)
    chnnl=10;
  else
    chnnl=chnnl-1;

  /* channelɥ쥹 */
  next_addr=chnnl;

  /* ϡɤνԤ */
  i=0;
  while ((ADC_EOC & (inb(adr+adc_data))) == 0){
    if (i >WLOOP) return -1;
    else usleep(10);
    
    i = i + 1;
  }

  /* Assert *CS */
  state=state&(~ADC_CS); 
  outb(adr+adc_control, state);

  /* channelꤷ,channelͤ */
  for (i = 0; i < ADC_DATA_WIDTH; i++){
    /* CLK  Up/Down ƥåȤ */
    /* CLK low */
    state=state&(~ADC_CLK);
    outb(adr+adc_control, state|(next_addr & ADC_ADDR));
    /* CLK high */
    state=state | ADC_CLK;
    outb(adr+adc_control, state|(next_addr & ADC_ADDR));

    if (i < ADC_ADDR_WIDTH)
      next_addr <<= 1;
    else
      next_addr = 0;

    /* ߡΥǡbitȤ˼ */
    dummy = dummy<<1;
    /* get serial data (inverted) */
    if ((ADC_CNVDATA & (inb(adr+adc_data))) == 0)
      dummy = dummy + 1;
  }
  /* CS OFF */
  state=((state&(~ADC_CLK))| ADC_CS);
  outb(adr+adc_control, state);

  /* ϡɤνԤ */
  /* 򤷤ʤchΥǡäƤޤ */
  i=0;
  while ((ADC_EOC & (inb(adr+adc_data))) == 0){
    if (i >WLOOP) return -1;
    else usleep(10);
    
    i = i + 1;
  }
  usleep(1000);

  /* Assert *CS */
  state=state&(~ADC_CS); 
  outb(adr+adc_control, state);

  /* ꤷchannelˤϤ⤦ */
  /* channelɥ쥹 */
  next_addr=chnnl;
  for (i = 0; i < ADC_DATA_WIDTH; i++){
    /* CLK  Up/Down ƥåȤ */
    /* CLK low */
    state=state&(~ADC_CLK);
    outb(adr+adc_control, state|(next_addr & ADC_ADDR));
    /* CLK high */
    state=state | ADC_CLK;
    outb(adr+adc_control, state|(next_addr & ADC_ADDR));

    if (i < ADC_ADDR_WIDTH)
      next_addr <<= 1;
    else
      next_addr = 0;
    /* Υ롼פꤷchΥǡbitȤ˼ */
    value= value<<1;
    /* get serial data (inverted) */
    if ((ADC_CNVDATA & (inb(adr+adc_data))) == 0)
      value=value+1;
  }

  /* CS OFF */
  state=((state&(~ADC_CLK))| ADC_CS); 
  outb(adr+adc_control, state);

  return value;
}

/* ADCΥѥ */
unsigned int ADC_close(unsigned int adr)
{
  outb(adr+adc_control, ADC_OFF);

  return ADC_OFF;
}









