#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>  /* #include < sys/un.h > */
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/ipc.h>
#include <sys/time.h>
#include "gmcpsock.h"


/* UNIXɥᥤǡѥȥ꡼෿åȤ롣*/
/* portnum: ݡֹ */
/* return: ʤ socket descriptor */
struct GmcpSocket Sock_Open(unsigned short portnum)
{
  struct GmcpSocket gsck;

  gsck.flg=0; gsck.fdx=0;

  /*  saddrȤ0ˤʤȡbind()ǥ顼뤳Ȥ */
  memset(&gsck.saddr, 0, sizeof(gsck.saddr));

  /* åȤ̾Ƥ */
  gsck.saddr.sin_family = PF_INET;
  gsck.saddr.sin_addr.s_addr = INADDR_ANY;
  gsck.saddr.sin_port = htons(portnum);

  /* åȺ */
  gsck.fdx = socket(PF_INET, SOCK_STREAM, 0);
  if (gsck.fdx < 0) {
    perror("socket:");
    gsck.flg=-1;
  }
  else {
    gsck.flg=0;
  }

  return gsck;
}


/* åȤ˥ɥ쥹Хɤlistenȯ */
/* fdx: socket descriptor */
/* return: ʤ0 */
struct GmcpSocket Sock_BL(struct GmcpSocket gsck)
{

  /* åȤ˥ɥ쥹Хɤ롣 */
  if (bind(gsck.fdx, (struct sockaddr *)&gsck.saddr, sizeof(gsck.saddr)) < 0){
    perror("bind");
    gsck.flg=-1;
    return gsck;
  }

  /* listen򥽥åȤФȯԤ */
  if (listen(gsck.fdx, BACKLOG) < 0) {
    perror("listen");
    gsck.flg=-1;
    return gsck;
  }

  gsck.flg=0;
  return gsck;
}

/* 饤Ȥ³׵򥢥ץ */
/* fdx: դsocket descriptor */
/* return: socket descriptor, 饤ȥåȥɥ쥹 */
struct GmcpSocket Sock_ACCPT(int fdx)
{
  int len;
  struct GmcpSocket csck;
  csck.flg=0; csck.fdx=0;
  memset(&csck.saddr, 0, sizeof(csck.saddr));

  /* ɥ쥹ĹƤ */
  len = sizeof(csck.saddr);

  /*
   * accept()ˤꡢ饤Ȥ³׵դ롣
   * ȡ饤Ȥ³줿åȤΥǥץ
   * csck.fdx֤롣csck.fdx̤̿ǽȤʤ롣
   */
  if ((csck.fdx = accept(fdx, (struct sockaddr *)&csck.saddr, &len)) < 0) {
    perror("accept");
    csck.flg=-1;
    close(csck.fdx);
  }

  return csck;
}

/* Ф˥ͥ */
/* fdx: socket descriptor */
/* servhost:̾, portX:ݡֹ */
/* return: socket descriptor, Хåȥɥ쥹 */
struct GmcpSocket Sock_CNCT(int fdx, char *servhost, int portX)
{
  struct hostent *hp;  
  struct GmcpSocket ssck;
  ssck.flg=0; ssck.fdx=fdx;
  memset(&ssck.saddr, 0, sizeof(ssck.saddr));

  /* åȤ̾Ƥ */
  if ((hp = gethostbyname(servhost)) == NULL) {
    perror("No such host in LAN");
    ssck.flg = -1;
    return ssck;
  }
  bcopy(hp->h_addr, &ssck.saddr.sin_addr, hp->h_length);
  ssck.saddr.sin_family = PF_INET;
  ssck.saddr.sin_port = htons(portX);

  /*
   *  СȤ³ߤ롣줬뤿ˤϡСǤ
   *  Υɥ쥹bind()ơlisten()ȯԤƤʤФʤʤ
   */

  if (connect(fdx, (struct sockaddr *)&ssck.saddr, sizeof(ssck.saddr)) < 0){
    perror("connect");
    ssck.flg=-1;
  } 

  return ssck;
}

/* λľ˺ƵưƤݡȤȤ褦 */
/* fdx: socket descriptor */
/* return: ʤ0 */
int Sock_ReUSE(int fdx)
{
  int sock_optval=1, ret=0;

  ret=setsockopt(fdx,SOL_SOCKET,SO_REUSEADDR,&sock_optval, sizeof(sock_optval));
  if (ret!=0)
    perror("sockopt(REUSEADDR):");

  return ret;
}

/* åȤΥॢȤtmot[sec] */
/* fdx: socket descriptor */
/* mode=0: , mode=other  */
/* return: ʤ0 */
int Sock_TimeOut(int fdx, int mode, double tmot)
{
  int sock_optval=1, ret=0;
  struct timeval time_optval={100, 100};

  /* keepalive ͭˤƥॢǽˤ */
  sock_optval=1;
  ret=setsockopt(fdx,SOL_SOCKET,SO_KEEPALIVE,&sock_optval, sizeof(sock_optval));
  if (ret!=0){
    perror("sockopt(KEEPALIVE):");
    return ret;
  }
  else {
    /* áܦäǥॢ */
    time_optval.tv_sec=(long) tmot;  
    time_optval.tv_usec=(long) ((tmot-time_optval.tv_sec)*1.0e6);    
  }

  /* åȤΥॢȤ */
  if (mode==0){
    /*  */
    ret=setsockopt(fdx,SOL_SOCKET,SO_RCVTIMEO,&time_optval, sizeof(time_optval));
  }
  else{
    /*  */
    ret=setsockopt(fdx,SOL_SOCKET,SO_SNDTIMEO,&time_optval, sizeof(time_optval));
  }

  if (ret!=0)
    perror("sockopt(TIMEOUT):");

  return ret;
}

/* IPγǼ */
/* csock: 饤ȱsocket */
/* return: IP */
struct GmcpIPinfo GetIPinfo(struct GmcpSocket csock)
{
  struct GmcpIPinfo ipinfo;
  struct in_addr intmp={0};

  ipinfo.ipaddr=0;
  memset(&ipinfo.ipname, 0, sizeof(ipinfo.ipname));

  /* åȥɥ쥹IPɥ쥹 */
  /* byte order ѴɬפϤʤ */
  /* clientnm=ntohl(caddr.sin_addr.s_addr); */
  ipinfo.ipaddr = csock.saddr.sin_addr.s_addr;
  intmp.s_addr = csock.saddr.sin_addr.s_addr;

  /* IPɥ쥹ʸˤ */
  sprintf(ipinfo.ipname, "%s\0", inet_ntoa(intmp));

  return ipinfo;
}


/* Хåե */
struct GmcpBuf GmcpInitBuf(struct GmcpBuf gbuf)
{
  gbuf.nb=0;
  gbuf.flag=0;

  memset(&gbuf.rbuf, 0, sizeof(gbuf.rbuf));
  memset(&gbuf.sbuf, 0, sizeof(gbuf.sbuf));

  return gbuf;
}

/* Хåե񤭹 */
struct GmcpBuf GmcpWriteBuf(struct GmcpBuf gbuf, char *ss)
{
  memset(&gbuf.sbuf, 0, sizeof(gbuf.sbuf));

  if (sizeof(ss)>SMAX){
    strncpy(gbuf.sbuf, ss, SMAX);
    gbuf.sbuf[SMAX-1]='\0';
  }
  else {
    strcpy(gbuf.sbuf, ss);
  }  

  return gbuf;
}

/* GMCPХåե */
/* fdx: socket descriptor */
/* fg: Хȿ, 0ʸĹǤ */
/* return: nbХȿ֤ */
struct GmcpBuf GmcpSBuf(int fdx, struct GmcpBuf gbuf, int fg)
{
  if (fg == 0)
    gbuf.nb = send(fdx, &gbuf.sbuf, strlen(gbuf.sbuf), 0);
  else
    gbuf.nb = send(fdx, &gbuf.sbuf, fg, 0);

  return gbuf;
}

/* GMCPХåե */
/* fdx: socket descriptor */
struct GmcpBuf GmcpRBuf(int fdx)
{
  struct GmcpBuf gbuf;

  gbuf.flag=0;
  memset(&gbuf.rbuf, 0, sizeof(gbuf.rbuf));

  gbuf.nb = recv(fdx, &gbuf.rbuf, sizeof(gbuf.rbuf),0);

  return gbuf;
}

/* GMCPХåե */
/* fdx: socket descriptor */
/* fg: Хȿ, 0ʸĹǤ */
struct GmcpBuf GmcpSRBuf(int fdx, struct GmcpBuf gbuf, int fg)
{

  if (fg == 0)
    gbuf.nb = send(fdx, &gbuf.sbuf, strlen(gbuf.sbuf), 0);
  else
    gbuf.nb = send(fdx, &gbuf.sbuf, fg, 0);

  if (gbuf.nb<1){
    gbuf.nb = -2;
    return gbuf;
  }
  else {
    gbuf.nb = recv(fdx, &gbuf.rbuf, sizeof(gbuf.rbuf),0);
    return gbuf;
  }
}

/* ХåեƤshort(2byte)Ѵ */
short Gbuf2shrt(struct GmcpBuf gbuf)
{
  short a=0, b=0, c=0;
 
  if (gbuf.rbuf[2]!='\n') return 0;

  a = (short) gbuf.rbuf[0];
  b = (short) gbuf.rbuf[1];
  c = (a&0x00ff) + ((b<<8)&0xff00);

  return c;
}

/* short(2byte)ѴХåեƤ */
struct GmcpBuf shrt2Gbuf(struct GmcpBuf gbuf, short a)
{
  short b=0;

  b = (a&0x00ff);
  gbuf.sbuf[0] = (char) b;
  b = ((a>>8)&0x00ff);
  gbuf.sbuf[1] = (char) b;
  gbuf.sbuf[2] = '\n';
  gbuf.sbuf[3] = '\0';

  return gbuf;
}

/* ХåեƤlong(4byte)Ѵ */
long Gbuf2lng(struct GmcpBuf gbuf)
{
  short a=0, b=0, c=0, d=0; 
  long x=0;
 
  if (gbuf.rbuf[4]!='\n') return 0;

  a = (long) gbuf.rbuf[0];
  b = (long) gbuf.rbuf[1];
  c = (long) gbuf.rbuf[2];
  d = (long) gbuf.rbuf[3];
  x = (a&0x000000ff) + ((b<<8)&0x0000ff00) 
    + ((c<<16)&0x00ff0000) + ((d<<24)&0xff000000);

  return x;
}

/* long(4byte)ѴХåեƤ */
struct GmcpBuf lng2Gbuf(struct GmcpBuf gbuf, long a)
{
  long b=0, c=0;

  c=a; b = (c&0x000000ff);
  gbuf.sbuf[0] = (char) b;
  c=a; b = ((c>>8)&0x000000ff);
  gbuf.sbuf[1] = (char) b;
  c=a; b = ((c>>16)&0x000000ff);
  gbuf.sbuf[2] = (char) b;
  c=a; b = ((c>>24)&0x000000ff);
  gbuf.sbuf[3] = (char) b;
  gbuf.sbuf[4] = '\n';
  gbuf.sbuf[5] = '\0';

  return gbuf;
}

/* Хåե(5byte)char+longѴ */
struct Gcsl Gbuf2five(struct GmcpBuf gbuf)
{
  short a=0, b=0, c=0, d=0;
  struct Gcsl ret={0, 0, 0, 0};

  if (gbuf.rbuf[5]!='\n') return ret;

  ret.c = gbuf.rbuf[0];
  a = (long) gbuf.rbuf[1];
  b = (long) gbuf.rbuf[2];
  c = (long) gbuf.rbuf[3];
  d = (long) gbuf.rbuf[4];
  ret.l = (a&0x000000ff) + ((b<<8)&0x0000ff00) 
    + ((c<<16)&0x00ff0000) + ((d<<24)&0xff000000);

  return ret;
}

/* char+long(5byte)ѴХåեƤ */
struct GmcpBuf five2Gbuf(struct GmcpBuf gbuf, struct Gcsl a)
{
  long b=0, x=0;

  gbuf.sbuf[0] = a.c;

  x=a.l; b = (x&0x000000ff);
  gbuf.sbuf[1] = (char) b;
  x=a.l; b =  ((x>>8)&0x000000ff);
  gbuf.sbuf[2] = (char) b;
  x=a.l; b = ((x>>16)&0x000000ff);
  gbuf.sbuf[3] = (char) b;
  x=a.l; b = ((x>>24)&0x000000ff);
  gbuf.sbuf[4] = (char) b;
  gbuf.sbuf[5] = '\n';
  gbuf.sbuf[6] = '\0';

  return gbuf;
}




