#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <machine/cpufunc.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>  /* #include < sys/un.h > */
#include <sys/ipc.h>

#include "smcb_reg.h"
#include "smcboard.h"
#include "ctrlcom.h"

#include "picoadc_reg.h"
#include "picoadc.h"

#include "gmcpsock.h"
#include "gmcp.h"

#include "gctrcom.h"


#define BOARD 0x280   /* default IO address */
#define COUNTER 0   /* default Counter */
#define ONOFF 0   /* defaul ѽ */

#define ODIR 1   /*  - */
#define OTYPE 1  /*  II */


#define ADC_ADR 0x378  /* Pico Tech. ADC */
#define SEM_FREE 1     /* ޥե å */
#define SEM_LOCK (-1)  /* ޥե å */


extern unsigned short SPEEDL;   /* ® */
extern unsigned short SPEEDM;   /* ® */
extern unsigned short SPEEDH;   /* ® */


unsigned int AxisAddr(int axis)
{
  unsigned int adr;
  
  /* ƼΥɥ쥹Υեå */
  if (axis==1) adr = OFFSET1;
  else if (axis==2) adr = OFFSET2;
  else if (axis==3) adr = OFFSET3;
  else if (axis==4) adr = OFFSET4;
  else adr=OFFSET1;
  
  adr = adr + BOARD;

  return adr;
}

/* ˥ޥ */

/* ּ */
/* ADCstate: ADC */
struct Gcsl Gctr_GetPos(int axis, struct ADCPara ADCstate)
{
  unsigned int adr;
  short cntab=0;
  int adcc=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Status X32s={0,0,0,0,0,0,0};
  struct sembuf smbuf[1];

  /* 0-31 counterA, 32-63 counertB */
  /* 64-75 ADC */
  if (axis>63) {
    if (ADCstate.adc==0){
      adcc = 0;
      cntab = 1;
      axis = axis - 64;
    }
    else {
      adcc = 1;
      axis = axis - 64;
    }
  }
  else if (axis>31) {
    adcc = 0;
    cntab = 1;
    axis = axis - 32;
  }
  else {
    adcc = 0;
    cntab = 0;
  }

  /* ADCϥơ0 + ֤ͤ */
  if (adcc!=0){
    ret.c = 0;
    /* å */
    smbuf[0].sem_flg = SEM_UNDO;
    smbuf[0].sem_op = SEM_LOCK;
    semop(ADCstate.semid, smbuf, 1);
    
    /* ADCͼ */
    ret.l = (long) ADC_get_value(ADC_ADR, axis, ADCstate.state);
  
    /* å */
    smbuf[0].sem_op = SEM_FREE;
    semop(ADCstate.semid, smbuf, 1);
  
    return ret;
  }
  /* ⡼ȥͼ */
  else {
    /* ƼΥɥ쥹Υեå */
    adr=AxisAddr(axis);
  }

  X32s=GetStatus(adr);  /* ơ */

  ret.c = 0x00;
  /* ⡼busy */
  if((X32s.DosaStatus&0x01)!=0)
    ret.c = 0x01;
  else 
    ret.c = 0x00;

  /*  */
  if ((X32s.SenserStatus&0x0100)!=0) 
    ret.c = ret.c+0x02;
  else ;

  /* ߥå */
  if((X32s.SenserStatus&0x0001)!=0)  
    ret.c = ret.c+0x04;
  else if((X32s.SenserStatus&0x0002)!=0) 
    ret.c = ret.c+0x08;
  else ;

  /* 弧 */
  if (GetOut(adr, 0)!=0) 
    ret.c = ret.c+0x10;
  else ;

  /* ߥե饰 */
  if((X32s.DosaStatus&0x20)!=0)
    ret.c = ret.c+0x20;
  else ;

  /*  */
  if((X32s.SenserStatus&0x0004)!=0)  
    ret.c = ret.c+0x40;
  else ;

  /* 顼 */
  if((X32s.DosaStatus&0x10)!=0)
    ret.c = ret.c+0x80;
  else ;
  
  /* ɸͼ */
  ret.l = GetCount(adr, cntab);

  return ret;
}

/* ® */
struct Gcsl Gctr_GetSpeed(int axis)
{
  unsigned int adr;
  int spd=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* ߤΰưIC */
  Smov=GetMove(adr, 0);

  spd = (int) Smov.speed;

  if (spd<SPEEDL+1) ret.c = 0;  /* ® */
  else if (spd>SPEEDH-1) ret.c = 2;  /* ® */
  else ret.c = 1;  /* ® */

  return ret;
}

/* 󥵡ּ */
struct Gcsl Gctr_GetSense(int axis)
{
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};
  struct X32Status X32s={0,0,0,0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  X32s=GetStatus(adr);  /* ơ */

  /* ߥåȾ */
  if((X32s.SenserStatus&0x0001)!=0)  
    ret.c = 1;
  else if((X32s.SenserStatus&0x0002)!=0) 
    ret.c = 2;

  /*  */
  else if ((X32s.SenserStatus&0x0100)!=0) 
    ret.c = 3;
  else ret.c = 0;

  return ret;
}

/* ưּ */
struct Gcsl Gctr_GetDosa(int axis)
{
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  if (GetOut(adr, 0)==0) {
    if (ChkBusy(adr)==0)
      ret.c = 0;
    else
      ret.c = -1;
  }
  else {
    if (ChkBusy(adr)==0)
      ret.c = 2;
    else
      ret.c = 1;
  }

  return ret;
}

/* 顼ּ */
struct Gcsl Gctr_GetErr(int axis)
{
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  ret.c = ChkErr(adr);

  return ret;
}


/* 桼ޥ */

/*  */
struct Gcsl Gctr_GoHome(int axis)
{
  int chk=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* ˸ˤ */
  if (ChkOrigin(adr)==1) return ret;

  /* ⡼Υӥå */
  if (ChkBusy(adr)!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = OriginGo(adr, ODIR, OTYPE);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* CW Limit */
struct Gcsl Gctr_LimitCW(int axis)
{
  int chk=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* CWߥåȤˤ */
  if (ChkLimit(adr)==1) return ret;

  /* ߤΰưIC */
  Smov=GetMove(adr, 0);

  /* ⡼Υӥå */
  if (ChkBusy(adr)!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = JogGo(adr, Smov, 0);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* CCW Limit */
struct Gcsl Gctr_LimitCCW(int axis)
{
  int chk=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* CCWߥåȤˤ */
  if (ChkLimit(adr)==2) return ret;

  /* ߤΰưIC */
  Smov=GetMove(adr, 1);

  /* ⡼Υӥå */
  if (ChkBusy(adr)!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = JogGo(adr, Smov, 0);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* ̾ */
struct Gcsl Gctr_Stop(int axis)
{
  int st=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  st = MotorStop(adr, 0);

  if (st==-1) ret.c = -1;
  else ret.c = 0;

  return ret;
}

/* ¨ */
struct Gcsl Gctr_Tesi(int axis)
{
  int st=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};
  
  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  st = MotorStop(adr, 1);

  if (st==-1) ret.c = -1;
  else ret.c = 0;

  return ret;
}

/* 弧ON */
struct Gcsl Gctr_ON(int axis)
{
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  if (ChkBusy(adr)!=0) ret.c = 1;
  else OutOnOff(adr, ONOFF, 1);

  return ret;
}

/* 弧OFF */
struct Gcsl Gctr_OFF(int axis)
{
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  if (ChkBusy(adr)!=0) ret.c = 1;
  else OutOnOff(adr, ONOFF, 0);

  return ret;
}

/* ® */
struct Gcsl Gctr_SetSpeed(int axis, short s)
{
  int chk=0;
  unsigned int adr;
  unsigned short spd=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0,0};

  if (s==2) spd = SPEEDH;       /* ® */
  else if (s==1) spd = SPEEDM;  /* ® */
  else spd = SPEEDL;            /* ® */

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* ߤΰưIC */
  Smov=GetMove(adr, 0);

  /* ⡼Υӥå */
  if (ChkBusy(adr)!=0) ret.c = 1;
  else {
    /* ®ѹ */
    Smov = SetSpeed(Smov,  Smov.stspeed, spd);
    chk = SetMove(adr, Smov);
    
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* PTPư */
struct Gcsl Gctr_PTPMove(int fdx, int axis, long l)
{
  int chk=0;
  unsigned int adr;
  unsigned long ul;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0,0};

  ul = labs(l);
  /* ư̤ */
  if (ul>16777215) {
    ret.c = -1;
    return ret;
  }

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* ߤΰưIC */
  Smov=GetMove(adr, 0);
  /* ư̤ */
  Smov=SetIdo(Smov, l);
  Smov=SetMaxIdo(Smov, ul);

  /* ⡼Υӥå */
  if (ChkBusy(adr)!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = PtpGo(adr, Smov, 0);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* Ͱư */
struct Gcsl Gctr_ABSMove(int fdx, int axis, long l)
{
  int chk=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  /* ư̤ */
  if (labs(l)>16777215) {
    ret.c = -1;
    return ret;
  }

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* ⡼Υӥå */
  if (ChkBusy(adr)!=0) ret.c = 1;
  else {
    /* Ͱư */
    chk = AbsGo(adr, l, 0, 0);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* 祰ư */
struct Gcsl Gctr_JOGMove(int fdx, int axis, char c)
{
  int chk=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0,0};

  /* ƼΥɥ쥹Υեå */
  adr=AxisAddr(axis);

  /* ߤΰưIC */
  Smov=GetMove(adr, 0);
  /* ư */
  if (c==0)
    Smov.dir = 0;
  else
    Smov.dir = 1;

  /* ߤΰư֤Ϲθʤߡ祰ư */
  chk = MotorStop(adr, 0);
  if (chk<0){
    ret.c = -1;
    return ret;
  }
  else if(chk==1&&c==0){
    return ret;
  }
  else if(chk==2&&c!=0){
    return ret;
  }
  else {
    chk = JogGo(adr, Smov, 0);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}


/* øޥ */

/* ۵ */
/* ֥⡼ɤǤʤΤ14¨ */
struct Gcsl Gctr_AllStop(int axis)
{
  int i=0;
  unsigned int adr;
  struct Gcsl ret={0,0,0,0};

  for (i=0; i<4; i++){
    /* ƼΥɥ쥹Υեå */
    adr=AxisAddr(i+1);

    MotorStop(adr, 1);
  }

  return ret;
}

