/* IBX-7208 stepping motor controller board library */
/*             written by Yachan                    */

/* ߥåȥåʤ
   +EL:+ߥߥå      -EL:-ߥߥå
   +SLD:+®ߥå     -SLD:-®ߥå
   ORGI:󥵡          EZ:󥳡Z
   ALM:               
   */

/* 4byte Υå */
/* long μϤʤɤ˻ */
struct Qbyte{
  unsigned char byte1;  /* ǲ̥Х */
  unsigned char byte2;
  unsigned char byte3;
  unsigned char byte4;  /* Ǿ̥Х */
};

/* X3203δ */
/* ư쥸Ǽ */
struct X32IniReg{
  unsigned char OutPls;  
  /* ѥ륹Ϥνʲbit
     bit      0                    1
     0    0.5pulseɥ   1.5pulseɥ
     2    +CW              +CCW 
     3    CW,CCWѥ륹         PULSE,DIRȼ
     ¾̤0 */
  
  unsigned char InEnc;  
  /* 󥳥Ͻ
     bit 0,1ʳ̤0
     bit0,bit1
     0 0: 2å     0 1: 2ꥯå4
     1 0: 2ꥯå2     1 1: 2ꥯå1     */

  unsigned short CountAB;  
  /* :󥿣, :󥿣½
     bit      0                     1
     0,8   ѥ륹ȡ    ѥ륹ȡ
     1,9   channel 1 ȡ    channel 1 ȡ
     3,11  channel 1     channel 1 ե
     5,13  signed 24bit            unsigned 24bit
     6,14  24bit⡼             32bit⡼
     ¾̤0 */

  unsigned char InpIni;  
  /* Ϥν 
     bit      0                     1
     0    SLDϸ®           SLDϸ®
     1    SLDϥ٥ư     SLDϥåư
     2    ORGI㴶        ORGIϹⴶ
     ¾̤0 */

  unsigned short InLogic;  
  /* :1, :2
     bit      0                     1
     0    +EL        +EL
     1    -EL        -EL
     2    ALM        ALM
     8    ORGI       ORGI
     9    EZ         EZ
     10   +SLD       +SLD
     11   -SLD       -SLD
     ¾̤0 */

  unsigned char OutLogic;  
  /* 
     bit      0                     1
     0    POUT       POUT
     1    PDIR       PDIR
     ¾̤0 */

  unsigned char CtlMode;  
  /* ⡼ɤν
     bit      0                     1
     0    Ʊȡ         Ʊȡ
     bit2,bit1  ®
     0 0: ư黻          0 1: եå
     1 0: ޥ˥奢    1 1: ®Ԥʤʤ
     3                 
     4    ľø®⡼       Sø®⡼
     5    ʪ                 
     ¾̤0  */

  unsigned short CtlCountAB;  
  /* :󥿣⡼, :󥿣⡼
     bit      0                       1
     0,8  顼߻ưꥢ   顼߻ưꥢ
     1,9  ߻ưꥢ     ߻ưꥢ
     ¾̤0 */

  unsigned char CtlCmp;  
  /* ѥ쥿⡼
     bit1, bit0  Pϥ쥯
     bit4, bit3  Pϥ쥯
     0 0: A      0 1: B
     1 0: C      1 1: ѥ졼쥸
     bit      0                   1
     6               2   
     ¾̤0 */

  unsigned long IntrMsk;
  /* ߥޥ쥸
     ̤顢ѥ륹ȯ,󥿳,
     󥵡,ѥ졼
     bit      0                             1
     0   ѥ륹ϴλߡ   ѥ륹ϴλߡ
     1   顼߳ߡ           顼߳ߡ
     2   ®ߡ           ®ߡ
     3   ®ٳߡ               ®ٳߡ
     5   ®ٳߡ           ®ٳߡ
     8   A꡼ߡ    A꡼ߡ
     9   Aܥߡ      Aܥߡ
     10  B꡼ߡ    B꡼ߡ
     11  Bܥߡ      Bܥߡ
     13  Cܥߡ      Cܥߡ
     16  ORGIߡ                 ORGIߡ
     17  EZߡ                   EZߡ
     18  INOߡ                  INOߡ
     24  P=Q ߡ                 P=Q ߡ
     25  P>Q ߡ                 P>Q ߡ
     ¾̤0 */
};

/* X3203β®   ९å f=16.384MHz  */
struct X32Acc{
  unsigned short FreqReg;     
  /* ȿΨ쥸 1-4096
     Ψ K[pps/step] = 250/FreqReg  */

  unsigned short AccReg;   
  /* ®졼ȥ쥸 1-16383
     ® g[pps/sec] = (f*K*AccReg)/131072)  */

  unsigned short DeAccReg;   
  /* ®졼ȥ쥸 1-16383
     ®졼ȤƱ */

  unsigned short SSection;  
  /* Sø® 1-8191 */

};

/* X3203ΰư */
/* ®, ư̤ */
struct X32Move{
  unsigned short speed;     
  /* ư® [pps] = K*sp */

  unsigned short stspeed;   
  /* ư® [pps] = K*stsp */

  unsigned long psp;   
  /* ưѥ 0-16777215 */

  unsigned long maxps; 
  /* ưѥ 0-16777215
     ƱưȤưμ */

  char dir;             
  /* ư 0:+, 1:- */
};


/* X3203Υơ */
/* ǥХμ˻ */
struct X32Status{
  unsigned char DosaStatus;  
  /* ư֥ơ
     bit      0                    1
     0                     ư
     1     ®Ǥʤ          ®
     2     ®Ǥʤ          ®
     4     顼ե饰OFF       顼ե饰ON
     5     ߥե饰OFF         ߥե饰ON
     6     ߥե饰OFF     ߥե饰ON
     ¾̤0 */

  unsigned char StopStatus;  
  /* װƥ
     bit      0                    1
     0     ORGIOFF            ORGION
     1     EZOFF              EZON
     2     +SLDOFF            +SLDON
     3     -SLDOFF            -SLDON
     ¾̤0 */

  unsigned char ErrStopStatus;  
  /* 顼װơ
     bit      0                    1
     0     +ELOFF             +ELON
     1     -ELOFF             -ELON
     2     ALMOFF             ALMON
     ¾̤0 */

  unsigned short SenserStatus;  
  /* 󥵾֥ơ 1, 2
     bit      0                    1
     0     +ELOFF             +ELON
     1     -ELOFF             -ELON
     2     ALMOFF             ALMON
     8     ORGIOFF            ORGION
     9     EZOFF              EZON
     10    +SLDOFF            +SLDON
     11    -SLDOFF            -SLDON
     ¾̤0 */

  unsigned char IntrStatus;  
  /* ߥƥ
     bit      0                          1
     0   ѥ륹ȯߥե饰OFF   ѥ륹ȯߥե饰ON
     1   󥿳ߥե饰OFF     󥿳ߥե饰ON
     2   󥵳ߥե饰OFF       󥵳ߥե饰ON
     3   ѥ쥿ߥե饰OFF   ѥ쥿ߥե饰ON
     ¾̤0 */

  unsigned char InpStatus;  
  /* ϥơ
     IN0  IN7 ΥӥåȾ  */

  unsigned char CmpStatus;  
  /* ѥ졼֥ơ
     bit      0                     1
     1      P=Q                P=Q 
     2      P>Q                P>Q 
     ¾̤0 */
};

/* X3203γߥե饰 */
/* ߤȯμ */
struct X32IntrFlg{
  unsigned char PlsFlg;  
  /* ѥ륹ȯߥե饰
     bit      0                                1
     0   ѥ륹ȯλߥե饰OFF   ѥ륹ȯλߥե饰ON
     1   顼߳ߥե饰OFF       顼߳ߥե饰ON
     2   ®ߥե饰OFF       ®ߥե饰ON
     3   ®ٳߥե饰OFF           ®ٳߥե饰ON
     5   ®ٳߥե饰OFF       ®ٳߥե饰ON
     ¾̤0 */

  unsigned char CountFlg;  
  /* 󥿳ߥե饰
     bit      0                                1
     0   Aߥե饰OFF  Aߥե饰ON
     1   Aܥߥե饰OFF  Aܥߥե饰ON
     2   Bߥե饰OFF  Bߥե饰ON
     3   Bܥߥե饰OFF  Bܥߥե饰ON
     5   Cܥߥե饰OFF  Cܥߥե饰ON
     ¾̤0 */

  unsigned char SenserFlg;  
  /* 󥵳ߥե饰
     bit      0                              1
     0   ORGIߥե饰OFF       ORGIߥե饰ON
     1   EZߥե饰OFF         EZߥե饰ON
     2   IN0ߥե饰OFF        IN0ߥե饰ON
     ¾̤0 */

  unsigned char CmpFlg;  
  /* ѥ졼ߥե饰
     bit      0                              1
     0     P=Q ߥե饰OFF      P=Q ߥե饰ON
     1     P>Q ߥե饰OFF      P>Q ߥե饰ON
     ¾̤0 */
};

struct X32Position{
  long goal;
  /* ɸȤƤѥ륹ɸ */

  long now;
  /* ߤΥѥ륹ɸ */

  char special;
  /* üʰ
     0: ̤ΰ,          1: 
     2: CWΥߥå,    3: CCWΥߥå */
};

struct Qbyte shrt2chr(unsigned short);
struct Qbyte lng2chr(unsigned long);
unsigned short chr2shrt(unsigned char, unsigned char);
unsigned long chr2lng(struct Qbyte);

void InitX32(unsigned int, struct X32IniReg);

struct X32IniReg defaultX32(void);
struct X32IniReg SetOutPls(struct X32IniReg, short, short, short);
struct X32IniReg SetInEnc(struct X32IniReg, short);
struct X32IniReg SetCountAB(struct X32IniReg, short, short, short, short);
struct X32IniReg SetInpIni(struct X32IniReg, short, short);
struct X32IniReg SetInLogic(struct X32IniReg, short, short, short, short);
struct X32IniReg SetOutLogic(struct X32IniReg, short);
struct X32IniReg SetCtlMode(struct X32IniReg, short, short, short, short);
struct X32IniReg SetCtlCountAB(struct X32IniReg, short, short);
struct X32IniReg SetCtlCmp(struct X32IniReg, short, short, short);
struct X32IniReg SetIntrMskPls(struct X32IniReg, unsigned char);
struct X32IniReg SetIntrMskCnt(struct X32IniReg, unsigned char);
struct X32IniReg SetIntrMskSns(struct X32IniReg, unsigned char);
struct X32IniReg SetIntrMskCmp(struct X32IniReg, unsigned char);

struct X32Move SetSpeed(struct X32Move, unsigned short, unsigned short);
struct X32Move SetIdo(struct X32Move, long);
struct X32Move SetMaxIdo(struct X32Move, unsigned long);

struct X32IniReg GetIni(unsigned int);
struct X32Status GetStatus(unsigned int);
struct X32IntrFlg GetIntFlag(unsigned int);
int SetMove(unsigned int, struct X32Move);
struct X32Move GetMove(unsigned int, char);
long GetCount(unsigned int, short);

int SetAcc(unsigned int, struct X32Acc);
struct X32Acc GetAcc(unsigned int);

void ResetComplete(unsigned int);
void PtpPlus(unsigned int);
void PtpMinus(unsigned int);
void CPtpPlus(unsigned int);
void CPtpMinus(unsigned int);
void JogPlus(unsigned int);
void JogMinus(unsigned int);
void CJogPlus(unsigned int);
void CJogMinus(unsigned int);
void OriginX(unsigned int, char, short);
void NStop(unsigned int);
void EStop(unsigned int);
void AllStop(unsigned int);
void ClearCntA(unsigned int);
void ClearCntB(unsigned int);
void ResetAccFlag(unsigned int);
void ResetCntFlag(unsigned int);
void ResetOrgFlag(unsigned int);
void ResetInpFlag(unsigned int);
void ResetCmpFlag(unsigned int);
void OutOnOff(unsigned int, short, short);
short GetOut(unsigned int, short);
short InpState(unsigned int, short);

