/* GMCP Server Programm */
/* gmcp-server version 1.0 */
/* written by ä */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <machine/cpufunc.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>  /* #include < sys/un.h > */
#include <arpa/inet.h>
#include <sys/time.h>
#include <signal.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <setjmp.h>

#include "picoadc_reg.h"
#include "picoadc.h"

#include "gmcpsock.h"
#include "gmcp.h"


#define MAXCLIENT 100   /* ³ξ */
#define	KAISU 10        /* ¾Ϣ³ߥå */ 

#define	FALSE	0
#define	TRUE	1

#define ADC_ADR 0x378  /* Pico Tech. ADC */


/* ץ򤹤뤿PID */
struct FmlyPID
{
  pid_t gmpid;  /* ХХץ */
  pid_t papid;  /* ƥץ̿ա */
  pid_t uclpid; /* ץ ʻ */
  pid_t pnum;   /* 饤ȿҥץ */
  pid_t unum;   /* ֥桼׿ҥץ */
};

/* ץ򤹤뤿ζͭ */
struct ShFlag
{
  int  *shead; 
  int  shmid;
  int  *ashead; 
  int  ashmid;
  int  *ushead;
  int  ushmid;  /* ¾ե饰 */
  int  *rshead;
  int  rshmid;  /* øե饰 */
};


FILE *fpl;
int iofl;
int cnctnum=0, usrnum=0, ky=0, oreda=0;
int pipstat=0, upipstat=0, endflg=0;
struct FmlyPID famlyp;
struct ShFlag ShMid={0,0,0,0,0,0,0,0};
jmp_buf env;
struct GmcpSocket csock;  /* 饤ȱܥå */
struct ADCPara ADCstate={0,0,0,0};  /* ADCξ */
unsigned short SPEEDL=50, SPEEDM=100, SPEEDH=200; 


/* ͭ꡼ */
void CloseShMid(void)
{
  shmctl(ShMid.shmid, IPC_RMID, 0);
  shmctl(ShMid.ashmid, IPC_RMID, 0);
  shmctl(ShMid.ushmid, IPC_RMID, 0);
  shmctl(ShMid.rshmid, IPC_RMID, 0);
  
  /* ޥե */
  semctl(ADCstate.semid, 0, IPC_RMID, (struct shmid_ds *) NULL);

  return;
}

/* ѻҥץνλ */
void sig_quitc(void)
{
  shmdt(ShMid.shead);  shmdt(ShMid.ashead);
  shmdt(ShMid.ushead); shmdt(ShMid.rshead);
  printf("Quit ProcessID: %d (client counter)\n", getpid());
  fflush(stdout);
  _exit(0);
}

/* ѻҥץΥꥻå */
void sig_reset(void)
{
  usrnum = 0;

  /* ѲΥե饰 */
  pipstat = 1;
}

/* ҥץνλ */
void sig_quit(void)
{
  pid_t tpid;

  tpid = getpid();

  fclose(fpl);
  close(csock.fdx);
  printf("Quit ProcessID: %d\n", tpid);
  fflush(stdout);
  _exit(0);
}

/* ҥץνλ */
void sig_quitx(void)
{
  pid_t tpid;

  tpid = getpid();

  fclose(fpl);
  close(csock.fdx);
  printf("Foreced to close ProcessID: %d\n", tpid);
  fflush(stdout);
  _exit(0);
}

/* ƥץνλ */
void sig_quitp(void)
{
  /* λե饰ΩƤ */
  endflg = 1;

  longjmp(env, 0);
}

/* 饤ȿȥå */
void sig_usr1(void)
{
  cnctnum = cnctnum + 1;

  /* ѲΥե饰 */
  pipstat = 1;
}

/* 饤ȿȥ */
void sig_usr2(void)
{
  if (cnctnum>0) cnctnum = cnctnum - 1;
  else cnctnum = 0;

  /* ѲΥե饰 */
  pipstat = 1;
}

/* 桼ȥå */
void sig_uusr1(void)
{
  usrnum = usrnum + 1;

  /* ѲΥե饰 */
  upipstat = 1;
}

/* 桼ȥ */
void sig_uusr2(void)
{
  if (usrnum>0) usrnum = usrnum - 1;
  else usrnum = 0;

  /* ѲΥե饰 */
  upipstat = 1;
}

/* λҥץΥ꥽ */
void sig_cld(void)
{
  int wt;
  wait(&wt);
}

/* ˤ볧 */
void sig_ucl(void)
{
  CloseShMid();
  printf("Uncle kill all of family\n");
  killpg(famlyp.gmpid, SIGKILL);
  if (ADCstate.adc!=0) ADC_close(ADC_ADR);
  close(iofl);
  exit(1);
}

/* Ե */
void unclemader(void)
{
  /* ޤλϽ㤬²򻴻 */
  signal(SIGHUP, (void (*)())sig_ucl);
  /* ԵƤ */
  kill(getpid(), SIGSTOP);
  pause();
}

/* ץ */
void grandmother(void)
{
  int wt;
  pid_t deadpid;

  while(1){
    deadpid=wait(&wt);
    /* ΤϿƤä */
    if (deadpid==famlyp.papid){
      /* ̤˻ */
      if (WIFEXITED(wt)==TRUE){
	/* 򻦤 */
	kill(famlyp.uclpid, SIGKILL);
	wait(&wt);
	/* ¾λҤɤã򽪤餻 */
	killpg(famlyp.gmpid, SIGTERM);
	wait(&wt);
	printf("Grand-Mother(PID:%d) die.\n", famlyp.gmpid);
	if (ADCstate.adc!=0) ADC_close(ADC_ADR);
	close(iofl);
	/* ˽λ */
	exit(0);
      }
      /* ƤλѻǤä */
      else {
	printf("Parent Process died abnormally\n");
      }
      CloseShMid();
      /* 򻦤 */
      kill(famlyp.uclpid, SIGKILL);
      wait(&wt);
      /* ¾λҤɤã򽪤餻 */
      killpg(famlyp.gmpid, SIGTERM);
      wait(&wt);
      printf("Grand-Mother(PID:%d) die.\n", famlyp.gmpid);
      /* ǰΤߤʻ͡ */
      killpg(famlyp.gmpid, SIGKILL);
      if (ADCstate.adc!=0) ADC_close(ADC_ADR);
      close(iofl);
      exit(1);
    }
    /* ΤϽä */
    else if (deadpid==famlyp.uclpid){
      /* 褵 */
      if ((famlyp.uclpid=fork())==0){
	printf("Uncle died. Restated!\n");
	unclemader();
      }   
    }
  }
}

/* 顼ȯ˥꥽ */
void NG_Close(int fdx)
{
  kill(famlyp.pnum, SIGKILL);
  kill(famlyp.unum, SIGKILL);
  CloseShMid();
  close(fdx);
  if (ADCstate.adc!=0) ADC_close(ADC_ADR);
  close(iofl);
  return;
}

/* ҥץǥ顼 */
void Child_Err(struct FmlyPID fam, int fdx)
{
  kill(fam.pnum, SIGUSR2);
  printf("Quit ProcessID: %d\n", getpid());
  fflush(stdout);
  fprintf(fpl,"\n");
  fclose(fpl);
  close(fdx);

  return;
}

/* ॢ */
/* rt:, st: */
int G_timeout(int fdx, long rt, long st)
{
  /* åȤμॢ  */
  if(Sock_TimeOut(fdx, 0, rt)!=0){
    close(fdx);
    fclose(fpl);
    close(iofl);
    _exit(1);	
  }
  /* åȤॢ  */
  if(Sock_TimeOut(fdx, 1, st)!=0){
    close(fdx);
    fclose(fpl);
    close(iofl);
    _exit(1);	
  }

  return 0;
}

/* ͭå */
int ChkAX(int sh, int axies)
{
  /* ͭå16ޤ */
  if ((axies>16)||(axies<1))
    return 0;
  if (((sh>>(axies-1))&0x0001)!=0)
    return 1;
  else
    return 0;
}

/* ͭե饰ON/OFF */
int AxOnOff(int sh, int axis, int a)
{
  int tmp=0;
  
  if ((axis>16)||(axis<1))
    return sh;

  tmp = 0x0001<<(axis-1);

  if (a!=0)
    sh = sh|tmp;
  else
    sh = sh&(~tmp);

  return sh;
}

int main(int argc, char *argv[])
{
  FILE   *fp;
  int    i=0, baxis=0, axchk=0, ccount=0;
  int    phead=0, aphead=0, uphead=0, rphead=0;
  int    portX=12000, maxc=3, paraC=0, paraH=200, paraM=100, paraL=50, kx=0;
  long   nowtime=0;
  int    flag=0, ng=0;
  char   buf[64];
  char   psswd[10];
  unsigned long pslist[MAXCLIENT];  /* IPΥꥹ */
  char   memclnt[256];
  int   comken=0;
  int    nego=0, clnm=0, usnm=0;
  struct GmcpSocket gsock;  /* 饤ȼեå */
  struct GmcpIPinfo clntip; /* 饤ȤIP */ 
  struct GmcpBuf gbuf1;  /* Хåե */
  struct GMCPCom anly;   /* GMCPޥ */
  struct Gcsl gret={0,0,0,0};  /* GMCPޥɤ֤ */


  /* ν */
  memset(&buf, 0, sizeof(buf));
  memset(&psswd, 0, sizeof(psswd));
  memset(&pslist, 0, sizeof(pslist));
  memset(&memclnt, 0, sizeof(memclnt));

  /* Хåեν */
  gbuf1 = GmcpInitBuf(gbuf1);

  /* ݥ󥿤ν */
  ShMid.shead=&phead; *ShMid.shead=0;
  ShMid.ashead=&aphead; *ShMid.ashead=0;
  ShMid.ushead=&uphead; *ShMid.ushead=0;
  ShMid.rshead=&rphead; *ShMid.rshead=0;

  /* necessary in order to use "outb","inb" I/O functions !! */
  if((iofl = open("/dev/io", 000)) < 0) {
    printf("Can't open I/O port!\n");
    exit(1);
  }

  /* ͭγ */
  ShMid.shmid=shmget(IPC_PRIVATE, sizeof(clnm), IPC_CREAT|0660);
  ShMid.ashmid=shmget(IPC_PRIVATE, sizeof(int), IPC_CREAT|0660);
  ShMid.ushmid=shmget(IPC_PRIVATE, sizeof(int), IPC_CREAT|0660);
  ShMid.rshmid=shmget(IPC_PRIVATE, sizeof(int), IPC_CREAT|0660);
  if((ShMid.shmid==-1)||(ShMid.ashmid==-1)){
    perror("Shmget");
    CloseShMid();
    exit(1);
  }
  else if((ShMid.ushmid==-1)||(ShMid.rshmid==-1)){
    perror("Shmget");
    CloseShMid();
    exit(1);
  }
  else {
    printf("shmid= %d, ushmid= %d, rshmid= %d\n", 
	   ShMid.shmid, ShMid.ushmid, ShMid.rshmid);
  }

  /* ޥեκ,  */
  ADCstate.semkey = ftok("gmcp-server", 'a');
  ADCstate.semid = semget(ADCstate.semkey, 1, IPC_CREAT|0660);
  semctl(ADCstate.semid, 0, SETVAL, 1);

  /* ХХץʳѡ */
  famlyp.gmpid=getpgrp();

  /* ХХ -> ƥץʬ */
  if ((famlyp.papid=fork())!=0){
    signal(SIGQUIT, SIG_IGN);
    signal(SIGTERM, SIG_IGN);
    signal(SIGHUP, SIG_IGN);
    signal(SIGTSTP, SIG_IGN);
    signal(SIGINT, SIG_IGN);

    /* ХХϽ */
    if ((famlyp.uclpid=fork())!=0){
      /* ХХϻԤФΤԤ */
      grandmother();
    }
    else {
      signal(SIGTSTP, SIG_IGN);
      /* ϲ²äƤ */
      unclemader();
    }
  }
  /* ҤؤαФϿƤȤλҤɤãԤʤ */
  else {
    /* ƥץID */
    famlyp.papid=getpid();
  }

  signal(SIGTSTP, SIG_IGN);
  signal(SIGHUP, SIG_IGN);
  signal(SIGQUIT, SIG_IGN);

  /* եɤ߹ */
  if ((fp=fopen("./server-g.conf","rt"))==NULL){
    printf("Can't open config file.\n");
    CloseShMid();
    exit(1);
  }
  else {
    /* ݡֹ */
    if (fscanf(fp, "PORT:%d\n", &portX)==0){
      printf("Port number is null.\n");
      fclose(fp);
      CloseShMid();
      exit(1);
    }
    /* ѥ */
    if (fscanf(fp, "PASS:%s\n", psswd)==0){
      printf("Password is null.\n");
      fclose(fp);
      CloseShMid();
      exit(1);
    }
    /* 祯饤ȿ */
    if(fscanf(fp, "MAX:%d\n", &maxc)==0){
      printf("MAX client is null.\n");
    }
    if(fscanf(fp, "ADC:%d\n", &paraC)==0){
      printf("ADC is null.\n");
      paraC = 0;
    }
    if(fscanf(fp, "SPEEDL:%d\n", &paraL)==0){
      printf("SPEEDL = 50\n");
      paraL = 50;
    }
    if(fscanf(fp, "SPEEDM:%d\n", &paraM)==0){
      printf("SPEEDM = 100\n");
      paraM = 100;
    }
    if(fscanf(fp, "SPEEDH:%d\n", &paraH)==0){
      printf("SPEEDH = 200\n");
      paraH = 200;
    }
    fclose(fp);
  }
  if (maxc<1) maxc = 1;
  else if(maxc>20) maxc = MAXCLIENT;

  if (paraC==0) ADCstate.adc = 0;
  else {
    ADCstate.adc = 1;
    /* ADC Open */
    ADCstate.state=ADC_open(ADC_ADR);
    usleep(5000);
  }

  /* ® */
  if (paraL<1){
    SPEEDL = 1;
  }
  else if (paraL>10000){
    SPEEDL = 10000;
  }
  else {
    SPEEDL = paraL;
  }

  if (paraM<SPEEDL){
    SPEEDM = SPEEDL;
  }
  else if (paraM>10000){
    SPEEDM = 10000;
  }
  else {
    SPEEDM = paraM;
  }

  if (paraH<SPEEDM){
    SPEEDH = SPEEDM;
  }
  else if (paraH>10000){
    SPEEDH = 10000;
  }
  else {
    SPEEDH = paraH;
  }

  /* 饤IPեɤ߹ */
  if ((fp=fopen("./member_ip.conf","rt"))==NULL){
    printf("Can't open ip config file.\n");
    CloseShMid();
    exit(1);
  }
  else {
    ky=0;
    /* 桼¤ĤޥϿ */
    while ((fscanf(fp, "%s\n", memclnt)!=0)&&(ky<maxc)){
      pslist[ky] = inet_addr(memclnt);
      ky = ky + 1;
    }
    fclose(fp);
  }

  /* ҥץǥ饤ȿʥʥѡ */
  if ((famlyp.pnum = fork())==0){
    signal(SIGTERM, (void (*)())sig_quitc);

    /* ץΥåץ򥷥ʥǹԤʤ */
    signal(SIGUSR1, (void (*)())sig_usr1);
    signal(SIGUSR2, (void (*)())sig_usr2);

    cnctnum = 0;
    ShMid.shead = shmat(ShMid.shmid,0,0);
    *ShMid.shead = 0;

    while(1){
      /* ֤ѲΥå */
      if(pipstat==1){
	/* ͭ */
	*ShMid.shead = cnctnum;
	printf("number of child process: %d\n", cnctnum);
	pipstat = 0;
      }
      else usleep(50);  /* ŬCPU */
    }
  }
  else {
    printf("client counter PID: %d\n", famlyp.pnum);
  }

  /* ҥץǥ桼ʥʥѡ */
  if ((famlyp.unum = fork())==0){
    signal(SIGTERM, (void (*)())sig_quitc);

    /* 桼Υꥻå */
    signal(SIGHUP, (void (*)())sig_reset);

    /* 桼Υåץ򥷥ʥǹԤʤ */
    signal(SIGUSR1, (void (*)())sig_uusr1);
    signal(SIGUSR2, (void (*)())sig_uusr2);

    usrnum = 0;
    ShMid.ashead = shmat(ShMid.ashmid,0,0);
    *ShMid.ashead = 0;

    while(1){
      /* ֤ѲΥå */
      if(upipstat==1){
	/* ͭ */
	*ShMid.ashead = usrnum;
	printf("number of USER: %d\n", usrnum);
	upipstat = 0;
      }
      else usleep(50);  /* ŬCPU */
    }
  }
  /* ƥץϼդǰ */
  else {
    signal(SIGCHLD, (void (*)())sig_cld);
    signal(SIGTERM, SIG_IGN);
    signal(SIGUSR2, SIG_IGN);
    signal(SIGQUIT, (void (*)())sig_quitp);
    printf("USR counter PID: %d\n", famlyp.unum);
    usleep(1000);
    /* ͭ */
    ShMid.shead = shmat(ShMid.shmid, 0, SHM_RDONLY);
    ShMid.ashead = shmat(ShMid.ashmid, 0, SHM_RDONLY);
    ShMid.ushead = shmat(ShMid.ushmid,0,0);
    *ShMid.ushead = 0;
    ShMid.rshead = shmat(ShMid.rshmid,0,0);
    *ShMid.rshead = 0;

    /* ȥ꡼෿åȤ롣*/
    gsock = Sock_Open(portX);
    if (gsock.fdx < 0) {
      NG_Close(gsock.fdx);
      exit(1);
    }
    else {
      /* λľ˺ƵưƤݡȤȤ褦 */
      if(Sock_ReUSE(gsock.fdx)!=0){
	NG_Close(gsock.fdx);
	exit(1);	
      }
    }
    
    /* åȤ˥ɥ쥹Хɤ,listenȯԡ */
    gsock=Sock_BL(gsock);
    if (gsock.flg < 0){
      NG_Close(gsock.fdx);
      exit(1);
    }  

    /* нλξ礳ˤ */
    endflg=0;
    setjmp(env);

    /* λե饰ΩäƵäƤ */
    if (endflg==1){
      /* ץ롼ΤQUIT */
      close(gsock.fdx); 
      killpg(famlyp.gmpid, SIGTERM);

      /* ͭΥǥå, */
      shmdt(ShMid.shead); shmdt(ShMid.ashead);
      shmdt(ShMid.ushead); shmdt(ShMid.rshead);
      CloseShMid();

      printf("Server(PID:%d) was terminated.\n", famlyp.papid);
      close(iofl);
      exit(0);
    }
    
    /* 饤ȤΥԤ³ */
    while(1){
      usleep(1000);  /* ŬCPU */
      clnm=MAXCLIENT;
      /* ꤫ͭ饯饤ȿ */
      clnm=(*ShMid.shead);
      printf("clnm=%d\n", clnm); 

      /* 饤ȿʤޤԤ */
      if (clnm>maxc-1){
	while(clnm>maxc-1){
	  clnm=(*ShMid.shead);
	  sleep(1); /* 1sec ֳ֤ǥå */
	}
	printf("clnm=%d\n", clnm);
      }
      
      printf("I am waiting for a connection.\n");
      
      ng=0;

      /* 饤Ȥ³׵դ롣 */
      csock = Sock_ACCPT(gsock.fdx);
      if (csock.fdx < 0) {
	NG_Close(gsock.fdx);
	exit(1);
      }      
      else{
	/* ҥץºݤ˱Ф */
	if(0 == fork()){ 
	  signal(SIGCHLD, SIG_IGN);
	  signal(SIGQUIT, SIG_IGN);
	  signal(SIGTERM, (void (*)())sig_quit);
	  close(gsock.fdx);  /* դåȤѺѤ */

	  /* ե륪ץ */
	  if ((fpl=fopen("./server-g.log","at"))==NULL){
	    printf("Can't open log file.\n");
	    close(csock.fdx);	    
	    close(iofl);
	    _exit(1);
	  }
      
	  time(&nowtime);
	  printf("Connection is done.\n");
	   
	  /* 饤ȤIPɥ쥹 */
	  clntip = GetIPinfo(csock);
	  printf("Client is %s\n", clntip.ipname);
	  
	  fprintf(fpl,"%s", ctime(&nowtime));
	  fprintf(fpl,"%s accessed.\n", clntip.ipname);

	  /* GMCP ǧ  */
	  /* åȤॢ 5sec  */
	  G_timeout(csock.fdx, 5, 5);

	  /* GMCP³ꥯȽ */
	  gbuf1 = GMCP_Caccept(csock.fdx);
	  if (gbuf1.flag!=0){
	    fprintf(fpl,"GMCP conect negotiation failure.\n\n");
	    printf("GMCP conect negotiation failure.\n");
	    /* ҥץλ³ */
	    Child_Err(famlyp, csock.fdx);
	    _exit(0);
	  }
	  else nego=0;
	  
	  /* GMCP¥ꥯȽ */
	  gbuf1 = GMCP_Paccept(csock.fdx, gbuf1);	  
	  if (gbuf1.flag==P_MNTR){
	    ng=0; 
	    comken = 0;
	    fprintf(fpl,"GMCP MNTR authority.\n\n");
	    printf("GMCP MNTR authority.\n");
	  }
	  else if (gbuf1.flag==P_USER){
	    ng=-1; 
	    comken = 1;
	    /* ROOT ˤ³ */
	    if((*ShMid.rshead)==-1){
	      printf("Cannot connect as USER now!\n");
	      fprintf(fpl, "USER was refused by ROOT.\n\n");
	      /* ҥץλ³ */
	      Child_Err(famlyp, csock.fdx);
	      _exit(0);
	    }
	    else {
	      fprintf(fpl,"GMCP USER authority.\n");
	      printf("GMCP USER authority.\n");
	    }

	    /* Ͽ줿ޥ󤫤ɤå */
	    for (kx=0; kx<ky; kx++){
	      if(clntip.ipaddr==pslist[kx]){
		ng=0;
		signal(SIGTSTP, (void (*)())sig_quitx);
		/* USRȥå */
		kill(famlyp.unum, SIGUSR1);
		break;
	      }
	    }
	    /* ϿƤʤ³Ĥ */
	    if (ng==-1){
	      printf("%s dose not have permission!\n", clntip.ipname);
	      fprintf(fpl, "Permission Error!\n\n");
	      /* ҥץλ³ */
	      Child_Err(famlyp, csock.fdx);
	      _exit(0);
	    }
	    else {
	      fprintf(fpl, "\n");
	    }
	  }
	  else if (gbuf1.flag==P_ROOT){
	    /* øƱ˰ͤ */
	    if((*ShMid.rshead)!=0){
	      fprintf(fpl,"ROOT is already login.\n");
	      printf("GMCP ROOT is already login.\n");
	      /* ҥץλ³ */
	      Child_Err(famlyp, csock.fdx);
	      _exit(0);
	    }
	    else {
	      ng=0; 
	      fprintf(fpl,"GMCP ROOT authority.\n");
	      printf("GMCP ROOT authority.\n");
	      printf("PASSWORD check\n");
	    }
	    /* GMCPѥɽ */
	    gbuf1 = GMCP_PassQ(csock.fdx, gbuf1, psswd);
	    if (gbuf1.flag==P_ROOT){
	      comken = 2;
	      printf("PASSWORD OK!\n");
	      fprintf(fpl, "\n");
	      /* øƱ˰ͤ */
	      *ShMid.rshead = 1;
	    }
	    else {
	      printf("PASSWORD failure!\n");
	      fprintf(fpl, "PASSWORD failure!\n\n");
	      /* ҥץλ³ */
	      Child_Err(famlyp, csock.fdx);
	      _exit(0);
	    }
	  }
	  else {
	    fprintf(fpl,"GMCP authority failure.\n\n");
	    printf("GMCP authority failure.\n");
	    /* ҥץλ³ */
	    Child_Err(famlyp, csock.fdx);
	    _exit(0);
	  }
	  
	  if (ng==0){
	    /* åȤॢ 60sec  */
	    G_timeout(csock.fdx, 60, 60);
	  }

	  flag=0;
	  /* ³ʤз֤ */
	  while(ng==0){
	    /* 饤ȤμƲ */
	    anly = GMCP_RevCOM(csock.fdx);
	    if (anly.kind==-2) {
	      printf("Connection is lost or Timeout!\n");
	      break;
	    }
	    /* øޥɤν */
	    if (anly.kind==2){
	      gbuf1 = GmcpInitBuf(gbuf1);
	      if (comken<anly.kind){
		gbuf1 = GmcpWriteBuf(gbuf1, "NG\n");
		gbuf1 = GmcpSBuf(csock.fdx, gbuf1, 0);
	      }
	      else {
		/* GMCP_ESTOP ʳϲ⤻֤äƤ */
		gret = GMCP_AUCOM(csock.fdx, anly, comken, ADCstate);
		/* л͡Ȥ */
		if (anly.command==GMCP_KILL){
		  gbuf1 = GmcpWriteBuf(gbuf1, "OK. I will die.\n");
		  gbuf1 = GmcpSBuf(csock.fdx, gbuf1, 0);
		  usleep(1000);
		  flag=1; break;
		}
		/* ʥ桼³ */
		else if (anly.command==GMCP_REFS){
		  printf("I will refuse new USER connection.\n");
		  *ShMid.rshead = -1;
		}
		/* ¾Υ桼³ */
		else if (anly.command==GMCP_XCUT){
		  printf("I will close USER connection.\n");
		  signal(SIGTSTP, SIG_IGN);
		  usleep(1000);
		  killpg(famlyp.gmpid, SIGTSTP);
		  usnm=(*ShMid.ashead);
		  kill(famlyp.unum, SIGHUP);
		  *ShMid.ushead = 0;
		  usleep(1000);
		  for (i=0; i<usnm; i++){
		    usleep(500);
		    kill(famlyp.pnum, SIGUSR2);
		  }
		}
	      }
	      /* ³Υå */
	      if (gret.kz==-1)
		break;
	      /* ³ */
	      else if (gret.kz==1){
		ng = 0;
	      }
	      else ng = 1;
	    }
	   
	    /* ޥɤμ¹ */
	    else if(anly.kind>=0) {
	      if (anly.kind==1) {
		if (oreda!=0){
		  if(baxis!=anly.axis) {
		    /* ѤΤͭ */
		    *ShMid.ushead = AxOnOff(*ShMid.ushead, baxis, 0);
		    baxis = 0;  oreda = 0;  
		    ccount = 0;  /* Ϣ³¹Բꥢ */
		    /* ¾ե饰å */
		    axchk = ChkAX((*ShMid.ushead), anly.axis);
		  }
		  else {
		    axchk = 0;  
		    ccount = ccount + 1;  /* Ϣ³¹Բ */
		  }
		}
		else {
		  /* ¾ե饰å */
		  axchk = ChkAX((*ShMid.ushead), anly.axis);
		}
	      }
	      else {
		ccount = 0;  /* Ϣ³¹Բꥢ */
	      }
	      
	      /* ޥɼ¹ */
	      if((anly.kind==1)&&(axchk!=0)){
		gret = GMCP_AUCOM(csock.fdx, anly, -2, ADCstate);
		printf("The axis is already used.\n");
	      }
	      else if (ccount>KAISU){
		gret = GMCP_AUCOM(csock.fdx, anly, -2, ADCstate);
		printf("The number of times over.\n");
	      }
	      else {
		gret = GMCP_AUCOM(csock.fdx, anly, comken, ADCstate);
	      }

	      /* ³Υå */
	      if (gret.kz==-1)
		break;
	      /* ³ */
	      else if (gret.kz==1){
		if ((anly.kind==1)&&(*ShMid.ushead==0)){
		  /* μ¾ե饰ON */
		  *ShMid.ushead = AxOnOff(*ShMid.ushead, anly.axis, 1); 
		  baxis = anly.axis;
		  oreda=1;
		}
		ng = 0;
	      }
	      else
		ng = 1;
	      
	      gbuf1 = GmcpInitBuf(gbuf1);
	      /* ֤ͤ򥯥饤Ȥ */
	      if (anly.ret==0) ;
	      else if (anly.ret==1){
		gbuf1.sbuf[0] = gret.c; 
		gbuf1.sbuf[1] = '\n'; gbuf1.sbuf[2] = '\0';
		gbuf1 = GmcpSBuf(csock.fdx, gbuf1, 3);
	      }
	      else if (anly.ret==2){
		gbuf1 = GmcpSBuf(csock.fdx, shrt2Gbuf(gbuf1,gret.s), 4);
	      }
	      else if (anly.ret==4){
		gbuf1 = GmcpSBuf(csock.fdx, lng2Gbuf(gbuf1,gret.l), 6);
	      }
	      else if (anly.ret==5)
		gbuf1 = GmcpSBuf(csock.fdx, five2Gbuf(gbuf1,gret), 7);
	      else ; 
	      
	    }
	    else break;
	  }
	  close(csock.fdx);
	  
	  /* л͡¹ */
	  if (flag==1){
	    fclose(fpl);
	    kill(famlyp.pnum, SIGTERM);
	    kill(famlyp.unum, SIGTERM);
	    kill(famlyp.papid, SIGQUIT);
	    _exit(0);
	  }
	  fclose(fpl);

	  /* USER logout */
	  if (comken==1){
	    /* ¾ͭ */
	    if ((baxis!=0)&&(oreda==1)){
	      *ShMid.ushead = AxOnOff(*ShMid.ushead, baxis, 0);
	      oreda=0;
	    }
	    /* USERȥ */
	    kill(famlyp.unum, SIGUSR2);
	  }
	  /* ølogout */
	  else if (comken==2){
	    *ShMid.rshead = 0;
	  }

	  /* 饤ȿȥ */
	  kill(famlyp.pnum, SIGUSR2);
	  printf("Quit ProcessID: %d\n", getpid());
	  fflush(stdout);
	  _exit(0);
	}
	/* ƥץ */
	else {
	  /* 饤ȿȥå */
	  kill(famlyp.pnum, SIGUSR1);
	  close(csock.fdx);
	}
      }
    }
  }
}





