#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <errno.h>
#include <machine/cpufunc.h>

#include "sgshot.h"

int iofl;

int main(int argc, char *argv[])
{

  struct SioPara spara={B38400, P_NONE, CS8, 1, F_HARD};

  static char buf1[15];
  static char buf2[]="G:\r\n";
  static char buf3[]="Q:\r\n";
  static char buf0[]="\r\n";
  char dummy, ack1, ack2, ack3;
  unsigned char lbuf[80];
  long pls=1000, xpls=0, ypls=0; 
  int err = -1, j=0, k=0;


  spara = defaultSIO();

  if (argc>1){
    pls = atol(argv[1]);
  }

  iofl = open("/dev/cuaa0", O_RDWR);

  if(pls<0){
    sprintf(buf1, "M:1-P%ld\r\n", labs(pls));
  }
  else {
    sprintf(buf1, "M:1+P%ld\r\n", pls);
  }

  if (iofl < 0)
    perror("/dev/cuaa0");

  if (InitSIO(iofl, spara) == 0) {


    //printf("Send M Command.\n");
 
    int wrote = so_write(iofl, buf1, strlen(buf1));
    //tcflush(remotefd, TCIOFLUSH);
 
    //printf("Send G Command.\n");
    wrote = so_write(iofl, buf2, strlen(buf2));
 
    //tcflush(remotefd, TCIOFLUSH);

    usleep(100000);

    do {
      wrote = so_write(iofl, buf3, strlen(buf3));
      
      err=0; k=0;
      for(j=0; j<40; j++){
	read(iofl, &dummy, sizeof(dummy));
	if(dummy!=' '){
	lbuf[k]=dummy;
	k = k +1;
	}
	if(dummy=='\n'){
	  lbuf[k]='\0';
	  break;
	}
	
	err=err+1;
      }
      
      if (err < 0)
	perror("remote read");
      else if(err>27){
	int i = 0, n = err;
	err = 0;
	sscanf(lbuf,"%ld,%ld,%c,%c,%c",&xpls,&ypls,&ack1,&ack2,&ack3);
	printf("Q: %d, %c, %c, %c\n", xpls, ack1, ack2, ack3);
      }
      sleep(1);
    }while(ack3=='B');
  }
    
  close(iofl);
  
  exit(0);
}
