/* IBX-7208 stepping motor controller board library   */
/*             written by Yachan                      */
/*             HW¸ʬ饤֥                   */
/* ؿѤ٤ˤϻ /dev/io open Ƥ */
/* ɬפ롣                                       */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <machine/cpufunc.h>
// #include <sys/systm.h>
#include "smcb_reg.h"
#include "smcboard.h"


/* unsigned short -> 1byte x 2 ʬ 
   byte1 Τۤ */
struct Qbyte shrt2chr(unsigned short x)
{
  struct Qbyte Dat={0,0,0,0};
  unsigned short a=0;

  a=x; a=a&0x00ff; Dat.byte1=(unsigned char) a;
  a=x>>8; a=a&0x00ff; Dat.byte2=(unsigned char) a;

  return Dat;
}

/* unsigned long -> 1byte x 4 ʬ 
   byte1 ǲ, byte4 Ǿ */
struct Qbyte lng2chr(unsigned long x)
{
  struct Qbyte Dat={0,0,0,0};
  unsigned long a=0, y=0;

  y=x;
  a=(y&0x000000ff); Dat.byte1=(unsigned char) a;
  y=x; a=((y>>8)&0x000000ff); Dat.byte2=(unsigned char) a;
  y=x; a=((y>>16)&0x000000ff); Dat.byte3=(unsigned char) a;
  y=x; a=((y>>24)&0x000000ff); Dat.byte4=(unsigned char) a;

  return Dat;
}

/* 1byte x 2 -> unsigned short ˷ 
   x:, y:  */
unsigned short chr2shrt(unsigned char x, unsigned char y)
{
  unsigned short a=0, b=0;

  b=(unsigned short) y;
  a=((unsigned short) x)+((b<<8)&0xff00);

  return a;
} 

/* 1byte x 4 -> unsigned long ˷ 
   byte1 ǲ */
unsigned long chr2lng(struct Qbyte Dat)
{
  unsigned long a=0, b=0;

  a=(unsigned long) chr2shrt(Dat.byte1, Dat.byte2);
  b=(unsigned long) chr2shrt(Dat.byte3, Dat.byte4);
  a=(a&0x0000ffff)+((b<<16)&0xffff0000);

  return a;
} 

/* X3203Aν  */
/* adr: μƬɥ쥹 */
void InitX32(unsigned int adr, struct X32IniReg X32)
{
  struct Qbyte Dat={0,0,0,0};

  /* ѥ륹Ϥν  */  
  outb( adr+RESSEL, INI_PLS);  outb( adr+WRDATA1, X32.OutPls);

  /* 󥳥Ͻ  */
  outb( adr+RESSEL, INI_ENC);  outb( adr+WRDATA1, X32.InEnc); 

  /* 󥿣  */
  Dat=shrt2chr(X32.CountAB);
  outb( adr+RESSEL, INI_CNTA);  outb( adr+WRDATA1, Dat.byte1);
  /* 󥿣½  */
  outb( adr+RESSEL, INI_CNTB);  outb( adr+WRDATA1, Dat.byte2);

  /* Ϥν  */
  outb( adr+RESSEL, INI_INP);  outb( adr+WRDATA1, X32.InpIni);

  /* ν */
  Dat=shrt2chr(X32.InLogic);
  outb( adr+RESSEL, INI_INL); 
  outb( adr+WRDATA1, Dat.byte1); outb( adr+WRDATA2, Dat.byte2);

  /* ϥե륿ν  */
  /* ΤȤⴶ٤˷ᤦ */
  outb( adr+RESSEL, INI_INF);  outb( adr+WRDATA1, 0x01); /* ⴶ١*/

  /* ν  */
  outb( adr+RESSEL, INI_OUTL);  outb( adr+WRDATA1, X32.OutLogic); 

  /* ⡼ɤν  */
  outb( adr+RESSEL, CTL_MODE);  outb( adr+WRDATA1, X32.CtlMode);

  /* A⡼ɤν  */
  Dat=shrt2chr(X32.CtlCountAB);
  outb( adr+RESSEL, CTL_CNTA);  outb( adr+WRDATA1, Dat.byte1);
  /* B⡼ɤν  */
  outb( adr+RESSEL, CTL_CNTB);  outb( adr+WRDATA1, Dat.byte2); 

  /* ѥ쥿⡼ɤν  */
  outb( adr+RESSEL, CTL_CMP);  outb( adr+WRDATA1, X32.CtlCmp); 

  /* ѥ륹ȯߤν  */
  Dat=lng2chr(X32.IntrMsk);
  outb( adr+RESSEL, INIR_PLS);  outb( adr+WRDATA1, Dat.byte1);
  /* 󥿳ߤν  */
  outb( adr+RESSEL, INIR_CNT);  outb( adr+WRDATA1, Dat.byte2);
  /* 󥵡ߤν  */
  outb( adr+RESSEL, INIR_SNS);  outb( adr+WRDATA1, Dat.byte3);
  /*ѥ졼ߤν  */
  outb( adr+RESSEL, INIR_CMP);  outb( adr+WRDATA1, Dat.byte4); 

  outb( adr+COM_DOSA, COM_OUT0H); /* SVONꥻå */
  outb( adr+COM_DOSA, COM_OUT1H); /* ERCCꥻå */
 
  return;
}

/*  X3203Adefault */
struct X32IniReg defaultX32(void)
{
  struct X32IniReg SmcX32={1,3,0,4,0,0,24,0,0,3};

  /* 
     ѥ륹: 1.5 ѥ륹ɥ,+CW,CW-CCW 2å
     󥳥Ͻ: 2ѥ륹,  1 
     󥿣,: ̤
     Ϥν: SLD:SLOW DOWN,SLD:LEVEL,ORGI:HIGH SENSE
     : 1,2 -
     : -
     ⡼: Ʊưʤ, ư黻, ֹԤʤ, S, ʪ
     󥿣,: ưꥢʤ
     ѥ쥿⡼: ̤
     ѥ륹ȯ: ߡ顼ߤγߤΤߤ
     󥿳, 󥵡, ѥ졼: ػ
   */

  return SmcX32;
}

/* X32IniRegΥСѿѹ */

/*  ѥ륹ϥ쥸ѹ */
/* a=0: 0.5, a=1:1.5; b=0:CW=+, b=1:CCW=+; c=0:CW; c=1:PULSE*/
struct X32IniReg SetOutPls(struct X32IniReg SmcX32, short a, short b, short c)
{
  unsigned char reg=0;

  /* ɥ */
  if (a==0) reg=reg+0x00;
  else reg=reg+0x01;

  /*  */
  if (b==0) reg=reg+0x00;
  else reg=reg+0x04;
  
  /* ѥ륹2åor */ 
  if (c==0) reg=reg+0x00;
  else reg=reg+0x08;

  SmcX32.OutPls=reg;

  return SmcX32;
}

/*  󥳡ϥ쥸ѹ */
/* a=0: , a=1:4, a=2:2, a=other:1 */
struct X32IniReg SetInEnc(struct X32IniReg SmcX32, short a)
{
  unsigned char reg=0;

  if (a==0) reg=reg+0x00;
  else if (a==1) reg=reg+0x01;
  else if (a==2) reg=reg+0x02;
  else reg=reg+0x03;

  SmcX32.InEnc=reg;

  return SmcX32;
}

/*  󥿽쥸ѹ */
/* a=0: A, a=other: B */
/* b=0: ξ disable, b=1: enable, b=2: channel1 enable, b=other: ξ enable */
/* c=0: channel1 +count, c=1: channel1 -count */
/* d=0: signed 24bit, d=1: unsigned 24bit, d=2: signed 32bit, b=other: unsigned 32bit */
struct X32IniReg SetCountAB(struct X32IniReg SmcX32, short a, short b, short c, short d)
{
  unsigned char regA=0, regB=0;
  unsigned short reg=0, btmp=0, atmp=0;

  /* ΥAʬCountABβ̡ */
  regA=(unsigned char) (SmcX32.CountAB & 0x00ff);
  /* ΥBʬCountABξ̡ */
  regB=(unsigned char) ((SmcX32.CountAB>>8) & 0x00ff);

  /* ѹΤϥA */
  if (a==0){
    /* ȯ󥿤ȥ󥳡󥿤̵ͭ */
    if (b==0) regA=0x00;
    else if (b==1) regA=0x01;
    else if (b==2) regA=0x02;
    else regA=0x03;

    /* 󥳡󥿤 */
    if (c==0) regA=regA+0x00;
    else regA=regA+0x08;

    /* 󥿤ϰ */
    if (d==0) regA=regA+0x00;
    else if (d==1) regA=regA+0x20;
    else if (d==2) regA=regA+0x40;
    else regA=regA+0x60;
  }
  /* ѹΤϥB */
  else {
    /* ȯ󥿤ȥ󥳡󥿤̵ͭ */
    if (b==0) regB=0x00;
    else if (b==1) regB=0x01;
    else if (b==2) regB=0x02;
    else regB=0x03;

    /* 󥳡󥿤 */
    if (c==0) regB=regB+0x00;
    else regB=regB+0x08;

    /* 󥿤ϰ */
    if (d==0) regB=regB+0x00;
    else if (d==1) regB=regB+0x20;
    else if (d==2) regB=regB+0x40;
    else regB=regB+0x60;
  }

  /* ̤˥A, ̤˥BΥѥ᡼ */
  atmp=(unsigned short) regA;
  btmp=(unsigned short) regB;
  reg=(atmp&0x00ff)+((btmp<<8)&0xff00);
  SmcX32.CountAB=reg;

  return SmcX32;
}

/*  Ͻ쥸ѹ */
/* a=0: SLD® ٥ư, a=1: SLD® ٥ư, 
   a=2: SLD® åư, a=other: SLD® åư */
/* b=0: ORG 㴶, b=other: ORG ⴶ */
struct X32IniReg SetInpIni(struct X32IniReg  SmcX32, short a, short b)
{
  unsigned char reg=0;

  /* ®ߥåȤư */
  if (a==0) reg=0x00;
  else if (a==1) reg=0x01;
  else if (a==2) reg=0x02;
  else reg=0x03;

  /* 󥵤δ */
  if (b==0) reg=reg+0x00;
  else reg=reg+0x04;

  SmcX32.InpIni=reg;

  return SmcX32;
}

/*  쥸ѹ */
/* a=0: EL , a=other: EL  */ 
/* b=0: ALM , b=other: ALM  */
/* c=0: ORG  EZ , c=1: ORG  EZ , 
   c=2: ORG  EZ , c=other: ORG  EZ  */
/* d=0: SLD , d=other: SLD  */
struct X32IniReg SetInLogic(struct X32IniReg SmcX32, short a, short b, short c, short d)
{
  unsigned char regA=0, regB=0;
  unsigned short reg=0, atmp=0, btmp=0;

  /* ߥåȥåʡܡס */
  if (a==0) regA=0x00;
  else regA=0x03;

  /* 󥹥å */
  if (b==0) regA=regA+0x00;
  else regA=regA+0x04;

  /* 󥳡Z */
  if (c==0) regB=0x00;
  else if (c==1) regB=0x01;
  else if (c==2) regB=0x02;
  else regB=0x03;

  /* ®ߥåʡܡס */
  if (d==0) regB=regB+0x00;
  else regB=regB+0x0c;

  /* ̤I, ̤II */
  atmp=(unsigned short) regA;
  btmp=(unsigned short) regB;
  reg=(atmp&0x00ff)+((btmp<<8)&0xff00);
  SmcX32.InLogic=reg;

  return SmcX32;
}

/*  쥸ѹ */
/* a=0: POUT  PDIR , a=1: POUT  PDIR ,
   a=2: POUT  PDIR , a=other: POUT  PDIR  */ 
struct X32IniReg SetOutLogic(struct X32IniReg SmcX32, short a)
{
  unsigned char reg=0;

  /*  */
  if (a==0) reg=0x00;
  else if (a==1) reg=0x01;
  else if (a==2) reg=0x02;
  else reg=0x03;

  SmcX32.OutLogic=reg;

  return SmcX32;
}

/*  ⡼쥸ѹ */
/* a=0: ƱȤʤ, a=other: Ʊ */
/* ® b=0: ư黻, b=1: եå, 
   b=2: ޥ˥奢, b=other: ®ʤ */
/* c=0: 椷ʤ, c=other:椹 */
/* d=0: ľ® ʪ, d=1: S® ʪ, 
   d=2: ľ® , d=other: S®  */
struct X32IniReg SetCtlMode(struct X32IniReg SmcX32, short a, short b, short c, short d)
{
  unsigned char reg=0;

  /* ƱȤ뤫ʤ */
  if (a==0) reg=0x00;
  else reg=0x01;

  /* ® */
  if (b==0) reg=reg+0x00;
  else if (b==1) reg=reg+0x02;
  else if (b==2) reg=reg+0x04;
  else reg=reg+0x06;

  /* 椹뤫ʤ */
  if (c==0) reg=reg+0x00;
  else reg=reg+0x08;

  /* ®⡼ ľ or S, ʪ or  */
  if (d==0) reg=reg+0x00;
  else if (d==1) reg=reg+0x10;
  else if (d==2) reg=reg+0x20;
  else reg=reg+0x30;  

  SmcX32.CtlMode=reg;

  return SmcX32;
}

/*  AB쥸ѹ */
/* A a=0: 顼ߥꥢʤ ߥꥢʤ, 
   a=1: 顼ߥꥢ ߥꥢʤ,
   a=2: 顼ߥꥢʤ ߥꥢ, 
   a=other: 顼ߥꥢ ߥꥢ */ 
/* B b=0: 顼ߥꥢʤ ߥꥢʤ, 
   b=1: 顼ߥꥢ ߥꥢʤ,
   b=2: 顼ߥꥢʤ ߥꥢ, 
   b=other: 顼ߥꥢ ߥꥢ */ 
struct X32IniReg SetCtlCountAB(struct X32IniReg SmcX32, short a, short b)
{
  unsigned short reg=0;
  unsigned char regA=0, regB=0;

  /* 顼ߤǥ󥿥ꥢ뤫ʤ */
  if (a==0) regA=0x00;
  else if (a==1) regA=0x01;
  else if (a==2) regA=0x02;
  else regA=0x03;

  /* ߤǥ󥿥ꥢ뤫ʤ */
  if (b==0) regB=0x00;
  else if (b==1) regB=0x01;
  else if (b==2) regB=0x02;
  else regB=0x03;

  /* ̤˥顼,̤ߤ */
  reg=((unsigned short) regA)+(((unsigned short) regA<<8)&0xff00);
  SmcX32.CtlCountAB=reg;

  return SmcX32;
}

/* ѥ졼쥸ѹ */
/* P a=0: A, a=1: B, 
   a=2: C, a=other: ѥ졼쥸 */ 
/* Q b=0: A, b=1: B, 
   b=2: C, b=other: ѥ졼쥸 */
/* c=0: , c=other: 2 */ 
struct X32IniReg SetCtlCmp(struct X32IniReg SmcX32, short a, short b, short c)
{
  unsigned char reg=0;

  /* PϤ */
  if (a==0) reg=0x00;
  else if (a==1) reg=0x01;
  else if (a==2) reg=0x02;
  else reg=0x03;

  /* QϤ */
  if (b==0) reg=reg+0x00;
  else if (b==1) reg=reg+0x08;
  else if (b==2) reg=reg+0x10;
  else reg=reg+0x18;

  /* Ӥ2Ӥ */
  if (c==0) reg=reg+0x00;
  else reg=reg+0x40;

  SmcX32.CtlCmp=reg;

  return SmcX32;
}

/* ѥ륹ȯߥޥ쥸ѹ */
struct X32IniReg SetIntrMskPls(struct X32IniReg SmcX32, unsigned char flag)
{
  unsigned long reg=0L, lflag=0;

  /* 1byteΤߥꥢ */
  reg=(SmcX32.IntrMsk&0xffffff00);
  /* ѥ륹ȯߥޥ */
  lflag=(unsigned long) flag;

  /* 1byte˥å */
  SmcX32.IntrMsk=reg+(lflag&0x000000ff);

  return SmcX32;
}

/* 󥿳ߥޥ쥸ѹ */
struct X32IniReg SetIntrMskCnt(struct X32IniReg SmcX32, unsigned char flag)
{
  unsigned long reg=0L, lflag=0;

  /* ̤2ܤ1byteΤߥꥢ */
  reg=(SmcX32.IntrMsk&0xffff00ff);
  /* 󥿳ߥޥ */
  lflag=(unsigned long) flag;

  /* ̤2ܤ1byte˥å */
  SmcX32.IntrMsk=reg+((lflag<<8)&0x0000ff00);

  return SmcX32;
}

/* 󥵳ߥޥ쥸ѹ */
struct X32IniReg SetIntrMskSns(struct X32IniReg SmcX32, unsigned char flag)
{
  unsigned long reg=0L, lflag=0;

  /* ̤2ܤ1byteΤߥꥢ */
  reg=(SmcX32.IntrMsk&0xff00ffff);
  /* 󥵳ߥޥ */
  lflag=(unsigned long) flag;

  /* ̤2ܤ1byte˥å */
  SmcX32.IntrMsk=reg+((lflag<<16)&0x00ff0000);

  return SmcX32;
}

/* ѥ졼ߥޥ쥸ѹ */
struct X32IniReg SetIntrMskCmp(struct X32IniReg SmcX32, unsigned char flag)
{
  unsigned long reg=0L, lflag=0;

  /* 1byteΤߥꥢ */
  reg=(SmcX32.IntrMsk&0x00ffffff);
  /* ѥ졼ߥޥ */
  lflag=(unsigned long) flag;

  /* 1byte˥å */
  SmcX32.IntrMsk=reg+((lflag<<24)&0xff000000);

  return SmcX32;
}

/* ư®ѹ */
/* x: ư® */
/* y: ǹ® */
struct X32Move SetSpeed(struct X32Move Smx, unsigned short x, unsigned short y)
{
  if(x>y){
    Smx.stspeed=y;
  }
  else {
    Smx.stspeed=x;
  }
  Smx.speed=y;

  return Smx;
}

/* ưѥ륹ѹ */
struct X32Move SetIdo(struct X32Move Smx, long x)
{
  /* ư */
  if (x<0) Smx.dir=1;
  else Smx.dir=0;

  /* ưѥ륹 */
  Smx.psp=labs(x);

  return Smx;
}

/* ưѥ륹ѹ */
struct X32Move SetMaxIdo(struct X32Move Smx, unsigned long x)
{
  /* ưѥ륹 */
  Smx.maxps=x;

  return Smx;
}

/* ߤIC */
/* adr: μƬɥ쥹 */
struct X32IniReg GetIni(unsigned int adr)
{
  struct X32IniReg X32={0,0,0,0,0,0,0,0,0,0};
  unsigned char a=0, b=0;
  struct Qbyte Dat={0,0,0,0};

  /* ѥ륹Ϥν  */  
  outb( adr+RESSEL, INI_PLS);  X32.OutPls=inb( adr+WRDATA1);

  /* 󥳥Ͻ  */
  outb( adr+RESSEL, INI_ENC);  X32.InEnc=inb( adr+WRDATA1); 

  /* 󥿣  */
  outb( adr+RESSEL, INI_CNTA); a=inb( adr+WRDATA1);
  /* 󥿣½  */
  outb( adr+RESSEL, INI_CNTB);  b=inb( adr+WRDATA1);
  X32.CountAB=chr2shrt(a, b);

  /* Ϥν  */
  outb( adr+RESSEL, INI_INP);  X32.InpIni=inb( adr+WRDATA1);

  /* ν */
  outb( adr+RESSEL, INI_INL); 
  a=inb( adr+WRDATA1); b=inb( adr+WRDATA2);
  X32.InLogic=chr2shrt(a, b);

  /* ν  */
  outb( adr+RESSEL, INI_OUTL);  X32.OutLogic=inb( adr+WRDATA1); 

  /* ⡼ɤν  */
  outb( adr+RESSEL, CTL_MODE);  X32.CtlMode=inb( adr+WRDATA1);

  /* A⡼ɤν  */
  outb( adr+RESSEL, CTL_CNTA);  a=inb( adr+WRDATA1);
  /* B⡼ɤν  */
  outb( adr+RESSEL, CTL_CNTB);  b=inb( adr+WRDATA1); 
  X32.CtlCountAB=chr2shrt(a, b);

  /* ѥ쥿⡼ɤν  */
  outb( adr+RESSEL, CTL_CMP);  X32.CtlCmp=inb( adr+WRDATA1); 

  /* ѥ륹ȯߤν  */
  outb( adr+RESSEL, INIR_PLS);  Dat.byte1=inb( adr+WRDATA1);
  /* 󥿳ߤν  */
  outb( adr+RESSEL, INIR_CNT);  Dat.byte2=inb( adr+WRDATA1);
  /* 󥵡ߤν  */
  outb( adr+RESSEL, INIR_SNS);  Dat.byte3=inb( adr+WRDATA1);
  /*ѥ졼ߤν  */
  outb( adr+RESSEL, INIR_CMP);  Dat.byte4=inb( adr+WRDATA1);
  X32.IntrMsk=chr2lng(Dat);

  return X32;
}

/* ߤΥơIC */
/* adr: μƬɥ쥹 */
struct X32Status GetStatus(unsigned int adr)
{
  struct X32Status X32s={0,0,0,0,0,0,0};
  unsigned char a=0, b=0;

  X32s.DosaStatus=inb( adr+COM_DOSA);   /*ư֥ơɤ߹ߡ*/

  outb( adr+RESSEL, STATUS_STP);  /*װơ쥸*/
  X32s.StopStatus=inb( adr+WRDATA1);  /*װƥɤ߹ߡ*/

  outb( adr+RESSEL, STATUS_ERR);   /*顼װơ쥸*/    
  X32s.ErrStopStatus=inb( adr+WRDATA1);    /*顼װƥɤ߹ߡ*/

  outb( adr+RESSEL, STATUS_SNS);   /*󥵾֥ơ쥸*/    
  a=inb( adr+WRDATA1);    /*󥵾֥ƥ1ɤ߹ߡ*/
  b=inb( adr+WRDATA2);    /*󥵾֥ƥ2ɤ߹ߡ*/
  X32s.SenserStatus=chr2shrt(a, b);

  X32s.IntrStatus=inb( adr+DOJI_INTR);    /*  ߥƥɤ߹ߡ*/

  outb( adr+RESSEL, STATUS_INP);   /*ϥơ쥸*/    
  X32s.InpStatus=inb( adr+WRDATA1);    /*  ϥƥɤ߹ߡ*/

  outb( adr+RESSEL, STATUS_CMP);   /*ѥ졼֥ơ쥸*/    
  X32s.CmpStatus=inb( adr+WRDATA1);    /*  ѥ졼֥ƥɤ߹ߡ*/

  return X32s;
}

/* ߤγߥե饰IC */
/* adr: μƬɥ쥹 */
struct X32IntrFlg GetIntFlag(unsigned int adr)
{
  struct X32IntrFlg X32i={0,0,0,0};

  outb( adr+RESSEL, FLG_PLS);   /*ѥ륹ȯߥե饰쥸*/    
  X32i.PlsFlg=inb( WRDATA1);    /*  ѥ륹ȯߥե饰ɤ߹ߡ*/

  outb( adr+RESSEL, FLG_CNT);   /*󥿳ߥե饰쥸*/    
  X32i.CountFlg=inb( adr+WRDATA1);    /*  󥿳ߥե饰ɤ߹ߡ*/

  outb( adr+RESSEL, FLG_SNS);   /*󥵳ߥե饰쥸*/    
  X32i.SenserFlg=inb( adr+WRDATA1);    /*  󥵳ߥե饰ɤ߹ߡ*/

  outb( adr+RESSEL, FLG_CMP);   /*ѥ졼ߥե饰쥸*/    
  X32i.CmpFlg=inb( adr+WRDATA1);    /*  ѥ졼ߥե饰ɤ߹ߡ*/

  return X32i;
}

/* ưICإå */
/* adr: μƬɥ쥹 */
int SetMove(unsigned int adr, struct X32Move Smc)
{
  struct Qbyte Dat={0,0,0,0}; 

  if (Smc.speed<1||Smc.speed>10000) return 1;
  if (Smc.stspeed<1||Smc.stspeed>10000) return 2;
  if (Smc.psp>16777215) return 3;
  if (Smc.maxps>16777215) return 4;

  outb(adr+RESSEL, STARTSPEED); /* ưȿ®١ˤ  */ 
  Dat= shrt2chr(Smc.stspeed);
  outb(adr+WRDATA1, Dat.byte1); 
  outb(adr+WRDATA2, Dat.byte2);

  outb(adr+RESSEL, MAXSPEED); /* ưȿ®١ˤ  */ 
  Dat= shrt2chr(Smc.speed);
  outb(adr+WRDATA1, Dat.byte1); 
  outb(adr+WRDATA2, Dat.byte2);

  outb(adr+RESSEL, OUTPLS); /* ϥѥ륹   */
  Dat= lng2chr(Smc.psp);
  outb(adr+WRDATA1, Dat.byte1); 
  outb(adr+WRDATA2, Dat.byte2);
  outb(adr+WRDATA3, Dat.byte3);

  outb(adr+RESSEL, LINEHKN); /* ľִʺȤʤ뼴͡   */
  Dat= lng2chr(Smc.maxps);
  outb(adr+WRDATA1, Dat.byte1); 
  outb(adr+WRDATA2, Dat.byte2);
  outb(adr+WRDATA3, Dat.byte3);

  return 0;
}

/* ߤΰưIC */
/* adr: μƬɥ쥹 */
struct X32Move GetMove(unsigned int adr, char dir)
{
  struct X32Move Smx={0,0,0,0,0};
  unsigned char a=0, b=0; 
  struct Qbyte Dat={0,0,0,0}; 

  outb(adr+RESSEL, MAXSPEED); /* ưȿ®١ˤ  */ 
  a=inb(adr+WRDATA1); b=inb(adr+WRDATA2);
  Smx.speed=chr2shrt(a, b);

  outb(adr+RESSEL, STARTSPEED); /* ưȿ®١ˤ  */ 
  a=inb(adr+WRDATA1); b=inb(adr+WRDATA2);
  Smx.stspeed=chr2shrt(a, b);

  outb(adr+RESSEL, OUTPLS); /* ϥѥ륹   */
  Dat.byte1=inb(adr+WRDATA1) ;
  Dat.byte2=inb(adr+WRDATA2);
  Dat.byte3=inb(adr+WRDATA3); Dat.byte4=0;
  Smx.psp=chr2lng(Dat);

  outb(adr+RESSEL, LINEHKN); /* ľִʺȤʤ뼴͡   */
  Dat.byte1=inb(adr+WRDATA1) ;
  Dat.byte2=inb(adr+WRDATA2);
  Dat.byte3=inb(adr+WRDATA3); Dat.byte4=0;
  Smx.maxps=chr2lng(Dat);

  /* ϥ쥸Ϥ狼ʤ */
  if(dir==0) Smx.dir=0;
  else Smx.dir=1;

  return Smx;
}

/* ߤΥͼ */
/* adr: μƬɥ쥹 */
/* a=0: A, a=other: B */
long GetCount(unsigned int adr, short a)
{
  struct Qbyte Count={0,0,0,0};
  long cnt=0;

  if (a==0)
    outb( adr+RESSEL, COUNTA);   /*A*/    
  else
    outb( adr+RESSEL, COUNTB);   /*B*/    
  
  Count.byte1=inb(adr+WRDATA1) ;
  Count.byte2=inb(adr+WRDATA2);
  Count.byte3=inb(adr+WRDATA3); 
  Count.byte4=inb(adr+WRDATA4);
  cnt= (long) chr2lng(Count);  

  return cnt;
}

/* ®IC˥å */
/* adr: μƬɥ쥹 */
int SetAcc(unsigned int adr, struct X32Acc Smc)
{
  struct Qbyte Dat={0,0,0,0};

  if (Smc.FreqReg<1||Smc.FreqReg>4096) return 1;
  if (Smc.AccReg<1||Smc.AccReg>16383) return 2;
  if (Smc.DeAccReg<1||Smc.DeAccReg>16383) return 3;
  if (Smc.SSection<1||Smc.SSection>8191) return 4;
  
  outb(adr+RESSEL, SYNCR); /* ȿΨ */   
  Dat=shrt2chr(Smc.FreqReg);
  outb(adr+WRDATA1, Dat.byte1); outb(adr+WRDATA2, Dat.byte2);

  outb(adr+RESSEL, ACCRATE); /* ®졼Ȥ */
  Dat=shrt2chr(Smc.AccReg);
  outb(adr+WRDATA1, Dat.byte1); outb(adr+WRDATA2, Dat.byte2);

  outb(adr+RESSEL, DCCRATE); /* ®졼Ȥ */
  Dat=shrt2chr(Smc.DeAccReg);
  outb(adr+WRDATA1, Dat.byte1); outb(adr+WRDATA2, Dat.byte2);

  outb(adr+RESSEL, SACCRG); /* Sø®֤ */
  Dat=shrt2chr(Smc.SSection);
  outb(adr+WRDATA1, Dat.byte1); outb(adr+WRDATA2, Dat.byte2);

  return 0;
}

/* ߤβ®IC */
/* adr: μƬɥ쥹 */
struct X32Acc GetAcc(unsigned int adr)
{
  struct X32Acc Smc={1,1,1,1};  
  unsigned char a=0, b=0; 

  outb(adr+RESSEL, SYNCR); /* ȿΨ */   
  a=inb(adr+WRDATA1); b=inb(adr+WRDATA2);
  Smc.FreqReg=chr2shrt(a, b);

  outb(adr+RESSEL, ACCRATE); /* ®졼Ȥ   */
  a=inb(adr+WRDATA1); b=inb(adr+WRDATA2);
  Smc.AccReg=chr2shrt(a, b);

  outb(adr+RESSEL, DCCRATE); /* ®졼Ȥ   */
  a=inb(adr+WRDATA1); b=inb(adr+WRDATA2);
  Smc.DeAccReg=chr2shrt(a, b);

  outb(adr+RESSEL, SACCRG); /* Sø®֤   */
  a=inb(adr+WRDATA1); b=inb(adr+WRDATA2);
  Smc.SSection=chr2shrt(a, b);

  return Smc;
}

/* ưλե饰򥯥ꥢ */
/* adr: μƬɥ쥹 */
void ResetComplete(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_RESET); /* ưλե饰򥯥ꥢ*/
  return;
}

/* +PTPư */
/* adr: μƬɥ쥹 */
void PtpPlus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_PTPP); /* ǥåư  */
  return;
}

/* -PTPư */
/* adr: μƬɥ쥹 */
void PtpMinus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_PTPM); /* ǥåư - */
  return;
}

/* +®ư */
/* adr: μƬɥ쥹 */
void CPtpPlus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_CPTPP); /* ®ǥåư  */
  return;
}

/* -®ư */
/* adr: μƬɥ쥹 */
void CPtpMinus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_CPTPM); /* ®ǥåư - */
  return;
}

/* +祰ư */
/* adr: μƬɥ쥹 */
void JogPlus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_JOGP); /* 祰ư  */
  return;
}

/* -祰ư */
/* adr: μƬɥ쥹 */
void JogMinus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_JOGM); /* 祰ư - */
  return;
}

/* +®祰ư */
/* adr: μƬɥ쥹 */
void CJogPlus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_CJOGP); /* ®祰ư  */
  return;
}

/* -®祰ư */
/* adr: μƬɥ쥹 */
void CJogMinus(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_CJOGM); /* ®祰ư - */
  return;
}

/*  */ 
/* adr: μƬɥ쥹 */
/* dir=0: +, dir=other:- */
/* stype:0-4 I-Vб, default->0 */
void OriginX(unsigned int adr, char dir, short stype)
{
  if(dir==0){
    if(stype==1) 
      outb(adr+COM_DOSA, COM_ORG2P);  /* 2 + */
    else if(stype==2)
      outb(adr+COM_DOSA, COM_ORG3P);  /* 3 + */
    else if(stype==3)
      outb(adr+COM_DOSA, COM_ORG4P);  /* 4 + */
    else if(stype==4)
      outb(adr+COM_DOSA, COM_ORG5P);  /* 5 + */
    else
      outb(adr+COM_DOSA, COM_ORG1P);  /* 1 + */
  }
  else{
    if(stype==1) 
      outb(adr+COM_DOSA, COM_ORG2M);  /* 2 - */
    else if(stype==2)
      outb(adr+COM_DOSA, COM_ORG3M);  /* 3 - */
    else if(stype==3)
      outb(adr+COM_DOSA, COM_ORG4M);  /* 4 - */
    else if(stype==4)
      outb(adr+COM_DOSA, COM_ORG5M);  /* 5 - */
    else
      outb(adr+COM_DOSA, COM_ORG1M);  /* 1 - */
  }
  
  return;
}

/* ® */
/* adr: μƬɥ쥹 */
void NStop(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_NSTOP); 

  return;
}

/* ¨ */
/* adr: μƬɥ쥹 */
void EStop(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_ESTOP); 

  return;
}

/*  */
/* adr: ܡɤΥɥ쥹 */
void AllStop(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_ASTOP); 

  return;
}

/* Aꥢ */
/* adr: μƬɥ쥹 */
void ClearCntA(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_CLRCA);

  return;
}

/* Bꥢ */
/* adr: μƬɥ쥹 */
void ClearCntB(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_CLRCB);

  return;
}

/* ø®ߥե饰ꥻå */
/* adr: μƬɥ쥹 */
void ResetAccFlag(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_RST_SLOW);  /* ®ϳߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_CONST);   /* ®ٳߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_MAXA);  /* ®ٳߥե饰ꥻå */

  return;
}

/* 󥿳ߥե饰ꥻå */
/* adr: μƬɥ쥹 */
void ResetCntFlag(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_RST_CACRY);  /* A꡼ߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_CABRO);  /* Aܥߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_CBCRY);  /* B꡼ߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_CBBRO);  /* Bܥߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_CCBRO);  /* Cܥߥե饰ꥻå */

  return;
}

/* 󥵳ߥե饰ꥻå */
/* adr: μƬɥ쥹 */
void ResetOrgFlag(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_RST_ORG);  /* ORGI󥵡ߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_EZ);  /* EZ󥵡ߥե饰ꥻå */

  return;
}

/* ϳߥե饰ꥻå */
/* adr: μƬɥ쥹 */
void ResetInpFlag(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_RST_IN);  /* IN0󥵡ߥե饰ꥻå */

  return;
}

/* ѥ졼ߥե饰ꥻå */
/* adr: μƬɥ쥹 */
void ResetCmpFlag(unsigned int adr)
{
  outb(adr+COM_DOSA, COM_RST_CMP0);  /* ѥ졼(P=Q)ߥե饰ꥻå */
  outb(adr+COM_DOSA, COM_RST_CMP1);  /* ѥ졼(P>Q)ߥե饰ꥻå */

  return;
}

/* ѽϥå */
/* adr: μƬɥ쥹 */
/* a=0: ѽOUT0, a=other: ѽOUT1 */
/* sw=0: Low, sw=other: High */
void OutOnOff(unsigned int adr, short a, short sw)
{
  if(a==0){
    if(sw==0)
      outb(adr+COM_DOSA, COM_OUT0L);  /* ѽOUT0Low */
    else
      outb(adr+COM_DOSA, COM_OUT0H);  /* ѽOUT0High */
  }
  else{
    if(sw==0)
      outb(adr+COM_DOSA, COM_OUT1L);  /* ѽOUT1Low */
    else
      outb(adr+COM_DOSA, COM_OUT1H);  /* ѽOUT1High */
  }

  return;
}

/* ѽϼ */
/* adr: μƬɥ쥹 */
/* a=0: ѽOUT0(SVON), a=other: ѽOUT1(ErCC) */
/* return: 0=Low 1=High */
short GetOut(unsigned int adr, short a)
{
  unsigned char b=0; 

  outb(adr+RESSEL, SET_OUT);  /* ѽ */
  b=inb(adr+WRDATA1);

  if (a==0){
    if((b&0x01)!=0) return 0;
    else return 1;
  }
  else {
    if((b&0x02)!=0) return 0;
    else return 1;
  }

  return (short) b;
}

/* ϼ */
/* adr: μƬɥ쥹 */
/* a=0: IN0(1RDY), a=other: IN1(INP) */
/* return: 0=Low 1=High */
short InpState(unsigned int adr, short a)
{
  unsigned char b=0; 

  outb(adr+RESSEL, STATUS_INP); /* Ͼ֥ơ */  
  b=inb(adr+WRDATA1);
  
  if (a==0){
    if((b&0x01)!=0) return 0;
    else return 1;
  }
  else {
    if((b&0x02)!=0) return 0;
    else return 1;
  }
}
