/* IBX-7208 stepping motor controller board library */
/*             written by Yachan                    */

enum parity_t {
	P_NONE,
	P_EVEN,
	P_ODD,
};

enum flow_t {
	F_NONE,
	F_HARD,
	F_X,
};

/* ߥåȥåʤ
   +EL:+ߥߥå      -EL:-ߥߥå
   +SLD:+®ߥå     -SLD:-®ߥå
   ORGI:󥵡          EZ:󥳡Z
   ALM:               
   */

/* 4byte Υå */
/* long μϤʤɤ˻ */
struct Qbyte{
  unsigned char byte1;  /* ǲ̥Х */
  unsigned char byte2;
  unsigned char byte3;
  unsigned char byte4;  /* Ǿ̥Х */
};

/* ꥢ̿ */
struct SioPara{
  int speed;  /* B38400 - B75 */
  enum parity_t parity;
  int data_bit;
  int stop_bit;
  enum flow_t flow_control;
};

/* X3203ΰư */
/* ®, ư̤ */
struct X32Move{
  unsigned short speed;     
  /* ư® [pps] = K*sp */

  unsigned short stspeed;   
  /* ư® [pps] = K*stsp */

  unsigned short acc;   
  /* ® [ms] */

};

/* X3203Υơ */
/* ǥХμ˻ */
struct X32Status{
  long xpos;
  /* 1ɸ */


  long ypos;
  /* 2ɸ */

  unsigned short DosaStatus;  
  /* ư֥ơ
      
     0      
     1     BUSY 
  */

  unsigned short StopStatus;  
  /* װƥ
     
     0     
     1     1LS
     2     2LS
     3     ξLS
     4     ¾
  */

  unsigned short ErrStopStatus;  
  /* 顼װơ
     
     0    
     1    ޥɥ顼
  */
};


struct X32Position{
  long goal;
  /* ɸȤƤѥ륹ɸ */

  long now;
  /* ߤΥѥ륹ɸ */

  char special;
  /* üʰ
     0: ̤ΰ,          1: 
     2: CWΥߥå,    3: CCWΥߥå */
};

struct Qbyte shrt2chr(unsigned short);
struct Qbyte lng2chr(unsigned long);
unsigned short chr2shrt(unsigned char, unsigned char);
unsigned long chr2lng(struct Qbyte);

int sel2(fd_set *, int, int);
int so_write(int, const void *, size_t);
void restore_local_terminal(void);
int save_local_terminal(int);
void set_status(struct termios *, struct SioPara);
int fd_init(int);
int set_fdstatus(int, struct SioPara);
int make_local_raw(int);
int read_remote(int, int);
int read_local(int, int);
int fnain(int, int);
int nain(int, const char *, struct SioPara);

struct SioPara defaultSIO(void);
int InitSIO(int, struct SioPara);

struct X32Move SetSpeed(struct X32Move, unsigned short, unsigned short);
int SetIdo(unsigned int, long);

int SetMove(unsigned int, struct X32Move);
struct X32Move GetMove(unsigned int);
struct X32Status GetStatus(void);

long GetCount(unsigned int);
int GoComm(void);

int PtpGo(unsigned int, long);
int JogGo(unsigned int, int);
int AbsGo(unsigned int, long);
int OriginGo(unsigned int);

void NStop(unsigned int);
void EStop(void);
void AllStop(void);
long ClearCount(unsigned int);

int ChkBusy(void);
int ChkLimit(unsigned int);
int ChkErr(void);
int MotorStop(unsigned int, int);
int OutOnOff(unsigned int, short);

