/* IBX-7208 stepping motor controller board library   */
/*             written by Yachan                      */
/*             HW¸ʬ饤֥                   */
/* ؿѤ٤ˤϻ /dev/io open Ƥ */
/* ɬפ롣                                       */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <machine/cpufunc.h>
#include <errno.h>
// #include <sys/systm.h>
// #include "smcb_reg.h"
#include "sgshot.h"

#define STOPLOOP 100


extern int iofl;

/* unsigned short -> 1byte x 2 ʬ 
   byte1 Τۤ */
struct Qbyte shrt2chr(unsigned short x)
{
  struct Qbyte Dat={0,0,0,0};
  unsigned short a=0;

  a=x; a=a&0x00ff; Dat.byte1=(unsigned char) a;
  a=x>>8; a=a&0x00ff; Dat.byte2=(unsigned char) a;

  return Dat;
}

/* unsigned long -> 1byte x 4 ʬ 
   byte1 ǲ, byte4 Ǿ */
struct Qbyte lng2chr(unsigned long x)
{
  struct Qbyte Dat={0,0,0,0};
  unsigned long a=0, y=0;

  y=x;
  a=(y&0x000000ff); Dat.byte1=(unsigned char) a;
  y=x; a=((y>>8)&0x000000ff); Dat.byte2=(unsigned char) a;
  y=x; a=((y>>16)&0x000000ff); Dat.byte3=(unsigned char) a;
  y=x; a=((y>>24)&0x000000ff); Dat.byte4=(unsigned char) a;

  return Dat;
}

/* 1byte x 2 -> unsigned short ˷ 
   x:, y:  */
unsigned short chr2shrt(unsigned char x, unsigned char y)
{
  unsigned short a=0, b=0;

  b=(unsigned short) y;
  a=((unsigned short) x)+((b<<8)&0xff00);

  return a;
} 

/* 1byte x 4 -> unsigned long ˷ 
   byte1 ǲ */
unsigned long chr2lng(struct Qbyte Dat)
{
  unsigned long a=0, b=0;

  a=(unsigned long) chr2shrt(Dat.byte1, Dat.byte2);
  b=(unsigned long) chr2shrt(Dat.byte3, Dat.byte4);
  a=(a&0x0000ffff)+((b<<16)&0xffff0000);

  return a;
} 

/*
 * select on 2 file descriptors.
 */
int sel2(fd_set *m, int f1, int f2)
{
	int maxfd = f1 > f2 ? f1 : f2;
	FD_ZERO(m);
	FD_SET(f1, m);
	FD_SET(f2, m);
	errno = 0;
	return select(maxfd + 1, m, NULL, NULL, NULL);
}/* sel2 */

/*
 * åȤ size_ Х
 */
int so_write(int so, const void *buf, size_t size_)
{
	int err = 0;
	int size = size_;
	const char *mv = buf;
	while (err == 0 && size >= 1) {
		int wrote = write(so, mv, size);
		if (wrote >= size) {
			size -= wrote;
			mv += wrote;
		}
		else
			err = -1;
	}/* while */
	if (err == 0)
		err = size_;
	return err;
}/* so_write */


static struct termios tio_save;
static int ti_fd;
static int quit_flag;

/*
 * ˥ߥʥξ֤᤹
 */
void restore_local_terminal(void)
{
	tcsetattr(ti_fd, TCSANOW, &tio_save);
}/* restore_local_terminal */

/*
 * ߥʥξ֤¸
 */
int save_local_terminal(int fd)
{
	int err = tcgetattr(fd, &tio_save);
	if (err < 0) {
		perror("tcgetattr");
	}
	else {
		ti_fd = fd;
		atexit(restore_local_terminal);
	}
	return err;
}/* save_local_terminal */


/*
 * Хѿ򻲾Ȥơߥʥξ
 * (speed, parity, data bits )ꤹ롣
 */
void set_status(struct termios *tio, struct SioPara spara)
{
	cfsetispeed(tio, spara.speed);
	cfsetospeed(tio, spara.speed);
	tio->c_cflag = (tio->c_cflag & ~CSIZE) | spara.data_bit;
	if (spara.stop_bit == 1)
		tio->c_cflag &= ~CSTOPB;
	else if (spara.stop_bit == 2)
		tio->c_cflag |= CSTOPB;
	switch (spara.parity) {
	case P_NONE:
		tio->c_cflag &= ~PARENB;
		break;
	case P_EVEN:
		tio->c_cflag = (tio->c_cflag | PARENB) & ~PARODD;
		break;
	case P_ODD:
		tio->c_cflag = tio->c_cflag | PARENB | PARODD;
		break;
	}/* switch */
	switch (spara.flow_control) {
	case F_NONE:
		tio->c_cflag &= ~CRTSCTS;
		tio->c_iflag &= ~(IXON | IXOFF);
		break;
	case F_HARD:
		tio->c_cflag |= CRTSCTS;
		tio->c_iflag &= ~(IXON | IXOFF);
		break;
	case F_X:
		tio->c_cflag &= ~CRTSCTS;
		tio->c_iflag |= (IXON | IXOFF);
		break;
	}/* switch */
}/* set_status */


/*
 * ꤵ줿եϥɥΥߥʥξ֤롣
 * raw ⡼ɤˤơCLOCAL ꤹ롣
 */
int fd_init(int fd)
{
	struct termios tio;
	int err = -1;
	if (tcgetattr(fd, &tio) < 0)
		perror("tcgetattr");
	else {
		cfmakeraw(&tio);
		tio.c_cflag |= CLOCAL; /* do not send SIGHUP to me! */
		if (tcsetattr(fd, TCSANOW, &tio) < 0)
			perror("tcsetattr");
		else
			err = 0;
	}
	return err;
}/* fd_init */

/*
 * ꤵ줿եϥɥˤĤơ
 * Хѿ򻲾Ȥơߥʥξ
 * (speed, parity, data bits )ꤹ롣
 */
int set_fdstatus(int fd, struct SioPara spara)
{
	struct termios tio;
	int err = -1;
	if (tcgetattr(fd, &tio) < 0)
		perror("tcgetattr");
	else {
		set_status(&tio, spara);
		if (tcsetattr(fd, TCSANOW, &tio) < 0)
			perror("tcsetattr");
		else
			err = 0;
	}
	return err;
}/* set_fdstatus */


/*
 * ߥʥ raw ⡼ɤˤ롣
 */
int make_local_raw(int fd)
{
  int err = 0;
  if (isatty(fd)) {
    err = save_local_terminal(fd);
    if (err == 0) {
      struct termios tio;
      if ((err = tcgetattr(fd, &tio)) < 0)
	perror("tcgetattr");
      else {
	cfmakeraw(&tio);
	if ((err = tcsetattr(fd, TCSANOW, &tio)) < 0)
	  perror("tcsetattr");
      }
    }
  }
  return err;
}/* make_local_raw */


/*
 * ⡼Ȥǡ褿
 */
int read_remote(int localfd, int remotefd)
{
	unsigned char lbuf[80];
	int err = read(remotefd, lbuf, sizeof(lbuf));
	if (err < 0)
		perror("remote read");
	else if (err == 0) {
		fprintf(stderr, "remote closed");
		err = -1;
	}
	else {
	  int i = 0, n = err;
	  err = 0;
	  while (err == 0 && i < n) {
	    if (fputc(lbuf[i], stdout) == EOF)
	      err = -1;

	    i++;
	  }/* while */
	  
	  fflush(stdout);
	}
	return err;
}/* read_remote */


/*
 * ܡɤϤä
 */
int read_local(int localfd, int remotefd)
{
	static int lastch = '\n';
	unsigned char lbuf[1];
	int err = read(localfd, lbuf, sizeof(lbuf));
	if (err < 0)
		perror("local read");
	else if (err == 0) {
		fprintf(stderr, "local closed\n");
		err = -1;
	}
	else {
		if ((lastch == '\n' || lastch == '\r') && lbuf[0] == '~') {
		  err = read(localfd, lbuf, sizeof(lbuf));
		  if (err < 0)
		    perror("local read");
		  else if (err == 0) {
		    fprintf(stderr, "local closed\n");
		    err = -1;
		  }
		  else {
		    //err = do_escape(lbuf[0], localfd, remotefd);
		    if (err != 0)
		      lastch = lbuf[0];
		    if (err == 1)
		      err = 0;
		  }
		}
		else {
			char *obuf = lbuf;
			int n = err;

			err = so_write(remotefd, obuf, n);
			if (err < 0) {
				perror("write remote");
			}
			else
				err = 0;
			lastch = lbuf[0];
		}
	}
	return err;
}/* read_local */


/*
 * ᥤ롼
 */
int fnain(int localfd, int remotefd)
{
	int err = 0;

	quit_flag = 0;
	while (quit_flag == 0 && err == 0) {
		fd_set fds;
		err = sel2(&fds, localfd, remotefd);
		if (err == -1)
			perror("select");
		else if (err == 0) {
			/* timeout */
		}
		else {
			if (FD_ISSET(remotefd, &fds)) {
				err = read_remote(localfd, remotefd);
			}
			if (FD_ISSET(localfd, &fds)) {
				err = read_local(localfd, remotefd);
			}
		}
	}/* while */
	return err;
}/* fnain */

/*
 * ե̾ dev ̤ƥꥢ̿Ԥ
 */
int nain(int localfd, const char *dev, struct SioPara spara)
{
	int err = -1;
	int remotefd = open(dev, O_RDWR);
	if (remotefd < 0)
		perror(dev);
	else {
		if (make_local_raw(localfd) == 0 && fd_init(remotefd) == 0 && set_fdstatus(remotefd, spara) == 0) {
		  err = fnain(localfd, remotefd);
		}
		close(remotefd);
	}
	return err;
}/* nain */

/*  SioPara default */
/*
  ܡ졼38400, ѥƥ̵, ǡ8, 
  ȥåץӥå1, ϡɥե
 */
struct SioPara defaultSIO(void)
{
  struct SioPara spara={B38400, P_NONE, CS8, 1, F_HARD};

  return spara;
}

/* /dev/cuaa0 */
/* fd: /dev/cuaa0Υϥɥ */
int InitSIO(int fd, struct SioPara spara)
{
  if (fd_init(fd) == 0 && set_fdstatus(fd, spara) == 0) {
    return 0;
  }
  else 	{
    perror("/dev/cuaa0 init");
    return -1;
  }
}

/* ư®ѹ */
/* x: ư® */
/* y: ǹ® */
struct X32Move SetSpeed(struct X32Move Smx, unsigned short x, unsigned short y)
{
  if(x>y){
    Smx.stspeed=y;
  }
  else {
    Smx.stspeed=x;
  }
  Smx.speed=y;

  return Smx;
}

/* ߤΥơIC */
/* adr: μƬɥ쥹 */
struct X32Status GetStatus(void)
{
  struct X32Status X32s={0,0,0,0,0};
  char buf3[]="Q:\r\n";
  char dummy, ack1, ack2, ack3;
  unsigned char lbuf[80];
  long xpls=0, ypls=0; 
  int err = -1, j=0, k=0;


  tcflush(iofl, TCIFLUSH);
  usleep(1000);
  err = so_write(iofl, buf3, strlen(buf3));

  if (err < 0)
    return X32s;
 
  err=0; k=0;
  for(j=0; j<40; j++){
    read(iofl, &dummy, sizeof(dummy));
    if(dummy!=' '){
      lbuf[k]=dummy;
      k = k +1;
    }
    if(dummy=='\n'){
      lbuf[k]='\0';
      break;
    }
    
    err=err+1;
  }
  
  if(err>27){
    int i = 0, n = err;
    err = 0;
    sscanf(lbuf,"%ld,%ld,%c,%c,%c",&xpls,&ypls,&ack1,&ack2,&ack3);

    X32s.xpos = xpls;
    X32s.ypos = ypls;

    if(ack1=='X')  X32s.ErrStopStatus=1;
    else X32s.ErrStopStatus=0;

    if(ack2=='K')  X32s.StopStatus=0;
    else if(ack2=='L') X32s.StopStatus=1;
    else if(ack2=='M') X32s.StopStatus=2;
    else if(ack2=='W') X32s.StopStatus=3;
    else  X32s.StopStatus=4;

    if(ack3=='R')  X32s.DosaStatus=0;
    else  X32s.DosaStatus=1;
  }

  return X32s;
}

/* ưѥ륹 */
/* axis: ֹ */
int SetIdo(unsigned int axis, long x)
{
  char buf1[15];
  /* ư */
  if (x<0) {
    sprintf(buf1, "M:%u-P%ld\r\n", axis, labs(x));
  }
  else {
    sprintf(buf1, "M:%u+P%ld\r\n", axis, labs(x));
  }

  /* ưѥ륹 */

  int wrote = so_write(iofl, buf1, strlen(buf1));

  return wrote;
}

/* ®򥻥å */
/* axis: ֹ */
int SetMove(unsigned int axis, struct X32Move Smc)
{
  char buf1[40];

  if (Smc.speed<1||Smc.speed>10000) return -1;
  if (Smc.stspeed<1||Smc.stspeed>10000) return -2;


  sprintf(buf1, "D:%uS%uF%uR%u\r\n", 
	  axis, Smc.stspeed, Smc.speed, Smc.acc);


  int wrote = so_write(iofl, buf1, strlen(buf1));

  return wrote;
}

/* ߤ® */
/* axis:  */
struct X32Move GetMove(unsigned int axis)
{
  struct X32Move X32s={200,2000,200};
  char buf3[8];
  char dummy;
  unsigned char lbuf[30];
  unsigned short stspeed=0, speed=0, acc=0; 
  int err = -1, j=0, k=0;


  sprintf(buf3, "?:D%u\r\n", axis);

  err = so_write(iofl, buf3, strlen(buf3));

  if (err < 0)
    return X32s;
 

  err=0; k=0;
  for(j=0; j<30; j++){
    read(iofl, &dummy, sizeof(dummy));
    if(dummy!=' '){
      lbuf[k]=dummy;
      k = k +1;
    }
    if(dummy=='\n'){
      lbuf[k]='\0';
      break;
    }
    
    err=err+1;
  }
  
  if(err>27){
    sscanf(lbuf,"S%uF%uR%u",&stspeed, &speed, &acc);

    X32s.stspeed = stspeed;
    X32s.speed = speed;
    X32s.acc = acc;
  }

  return X32s;
}


/* ߤΥͼ */
/* axis:  */
long GetCount(unsigned int axis)
{
  struct X32Status X32s={0,0,0,0,0};

  long cnt=0;

  X32s = GetStatus();

  if (axis==1)
    cnt = X32s.xpos;   /*1*/    
  else   
    cnt = X32s.ypos;   

  return cnt;
}

/* GO ޥ */
int GoComm(void)
{
  char buf2[]="G:\r\n";

  int wrote = so_write(iofl, buf2, strlen(buf2));

  return wrote;
}

/* PTPư */
/* axis:  */
int PtpGo(unsigned int axis, long x)
{
  int rt=0;

  rt = SetIdo(axis, x);

  if(rt<0) return rt;  /* ͤʤ꥿ */
  
  rt = GoComm();

  if(rt<0) return rt;
  else return 0;
}

/* 祰ư */
/* axis:  */
/* i=0: +, i=other: - */
int JogGo(unsigned int axis, int i)
{
  int rt=0;
  char buf1[8];

  if(i==0){
    sprintf(buf1, "J:%u+\r\n", axis);
  }
  else {
    sprintf(buf1, "J:%u-\r\n", axis);
  }

  rt = so_write(iofl, buf1, strlen(buf1));
  if(rt<0) return rt;  /* ͤʤ꥿ */

  rt = GoComm();

  if(rt<0) return rt;
  else return 0;
}

/* Ͱư */
/* axis:  */
/* pos: ɸ */
int AbsGo(unsigned int axis, long pos)
{
  int rt=0;
  char buf1[15];

  if (labs(pos)>8388608) {    
    return -1;
  }

  if(pos<0){
    sprintf(buf1, "A:%u-P%ld\r\n", axis, labs(pos));
  }
  else {
    sprintf(buf1, "A:%u+P%ld\r\n", axis, labs(pos));
  }

  rt = so_write(iofl, buf1, strlen(buf1));
  if(rt<0) return rt;  /* ͤʤ꥿ */

  rt = GoComm();

  if(rt<0) return rt;
  else return 0;
}

/*  */ 
/* axis:  */
int OriginGo(unsigned int axis)
{
  char buf1[8];

  sprintf(buf1, "H:%u\r\n", axis);

  int rt = so_write(iofl, buf1, strlen(buf1));

  if(rt<0) return rt;
  else return 0;
}

/* ® */
/* axis:  */
void NStop(unsigned int axis)
{
  char buf1[8];

  sprintf(buf1, "L:%u\r\n", axis);

  int wrote = so_write(iofl, buf1, strlen(buf1));


  return;
}

/* ۵ */
void EStop(void)
{
  char buf1[]="L:E\r\n";

  int wrote = so_write(iofl, buf1, strlen(buf1));

  return;
}

/*  */
void AllStop(void)
{
  char buf1[]="L:W\r\n";

  int wrote = so_write(iofl, buf1, strlen(buf1));

  return;

  return;
}

/* 󥿤Υꥢ */
/* axis:  */
/* return: ꥢΥ */
long ClearCount(unsigned int axis)
{
  long cnt=0;
  char buf1[8];

  cnt=GetCount(axis); /* ͤμ */

  sprintf(buf1, "R:%u\r\n", axis);

  int wrote = so_write(iofl, buf1, strlen(buf1));

  return cnt;
}

/* ⡼Υӥå */
/* return: 0=idle, 1=busy */
int ChkBusy(void)
{
  char buf3[]="!:\r\n";
  char dummy, ack3;
  unsigned char lbuf[10];
  int err = -1, k=0, j=0;

  err = so_write(iofl, buf3, strlen(buf3));

  if (err < 0) return -1;
 
  err=0; k=0;
  for(j=0; j<10; j++){
    read(iofl, &dummy, sizeof(dummy));
    if(dummy!=' '){
      lbuf[k]=dummy;
      k = k +1;
    }
    if(dummy=='\n'){
      lbuf[k]='\0';
      break;
    }
    err=err+1;
  }
  
  if(err>0){
    sscanf(lbuf,"%c",&ack3);

    if(ack3=='R') return 0;
    else  return 1;
  }
  else return -1;
}

/* ߥåȥåå */
/* axis:  */
/* return: 0=normal, 1=limit */
int ChkLimit(unsigned int axis)
{
  int lmt=0;
  struct X32Status X32s={0,0,0,0,0};

  X32s = GetStatus();  /* ơ */

  /* 󥵾֥ơå */
  if(axis==1){
    if((X32s.StopStatus==1)||(X32s.StopStatus==3)){
      lmt=1;  /* CW limit */
    }
    else {
      lmt=0;  /* normal */
    }
  }
  else {
    if((X32s.StopStatus==2)||(X32s.StopStatus==3)){
      lmt=1;  /* CW limit */
    }
    else {
      lmt=0;  /* normal */
    }
  }

  return lmt;
}


/* 顼å */
/* return: 0=normal, 1=error */
int ChkErr(void)
{
  struct X32Status X32s={0,0,0,0,0};

  X32s = GetStatus();  /* ơ */

  /* 󥵾֥ơå */

  /* ư֥ơå */
  if(X32s.ErrStopStatus==0){
    return 0;  /*  */
  }
  else {
    return 1;  /* 顼 */
  }
}


/* ̿ */
/* axis:  */
/* i=0: normal,  i=other emergency */
/* return: 0=, -1=ߤʤ, 1=limit */
int MotorStop(unsigned int axis, int i)
{
  int x=0, y=0;

  if(i==0) {
    NStop(axis); /* ® */
  }
  else {
    EStop();  /* ۵ */
  }
  usleep(2);

  /* ⡼ưå */
  x=0; y=0;
  while((ChkBusy()!=0)&&(y==0)){
    x=x+1;
    if (x>STOPLOOP){
      y=1;
    }
    usleep(2);
  }
  if (y==1) return -1; /* ߤʤ */

  return ChkLimit(axis);  /* ߥåȥåΥå */
}

/* 弧ON OFF */
/* axis:  */
/* sw: 1 ON, 0 OFF */
int OutOnOff(unsigned int axis, short sw)
{
  char buf1[15];

  if (sw==1){
    sprintf(buf1, "C:%u1\r\n", axis);
  }
  else {
    sprintf(buf1, "C:%u0\r\n", axis);
  }

  int rt = so_write(iofl, buf1, strlen(buf1));

  if(rt<0) return rt;
  else return 0;

  return;
}
