/* GMCP ץȥ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>  /* #include < sys/un.h > */
#include <sys/time.h>
#include <termios.h>

#include "picoadc_reg.h"
#include "picoadc.h"

#include "gmcpsock.h"
#include "gmcp.h"
#include "gctrcom-sg.h"


/* ʸ */
int GMCP_StrCmp(char *buf, int cmm)
{
  int res=1;

  switch(cmm) {
  case 0: res = strncmp(buf, "GMCP/", 5);    
    break;
  case 1: res = strncmp(buf, GHEAD, 9);    
    break;
  case 2: res = strncmp(buf, GACCEPT, 12);    
    break;
  case 3: res = strncmp(buf, GREJECT, 12);    
    break;
  case 4: res = strncmp(buf, GUSER, 10);    
    break;
  case 5: res = strncmp(buf, GMNTR, 10);    
    break;
  case 6: res = strncmp(buf, GROOT, 10);    
    break;
  case 7: res = strncmp(buf, GPASS, 11);    
    break;
  case 8: res = strncmp(buf, GREFUSE, 12);    
    break;

  default: res = strncmp(buf, GHEAD, 9); 
  }

  return res;
}


/* ǧڽ */

/* ³ꥯȼդ(for server) */
struct GmcpBuf GMCP_Caccept(int fdx)
{
  struct GmcpBuf gbuf;

  gbuf = GmcpInitBuf(gbuf);
  gbuf = GmcpRBuf(fdx);

  /* ꤬REJECT, ʤACCEPT֤ */
  if (GMCP_StrCmp(gbuf.rbuf, 1)!=0){
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, GREJECT), 0);
    close(fdx);
    gbuf.flag = -1;
  }
  else {
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, GACCEPT), 0);
    if (gbuf.nb<1) {
      close(fdx);
      gbuf.flag = 1;
    }
    else gbuf.flag = 0;
  }

  return gbuf;
}

/* ³ꥯ׵(for client) */
struct GmcpBuf GMCP_Crqst(int fdx)
{
  struct GmcpBuf gbuf;

  gbuf = GmcpInitBuf(gbuf);

  gbuf = GmcpSRBuf(fdx, GmcpWriteBuf(gbuf, GHEAD), 0);
  if (GMCP_StrCmp(gbuf.rbuf, 2)==0){
    gbuf.flag = 0;
  }
  else if (GMCP_StrCmp(gbuf.rbuf, 3)==0){
    gbuf.flag = -1;
    close(fdx);
  }
  else {
    gbuf.flag = 1;
    close(fdx);
  }

  return gbuf;
}

/* ¥ꥯȼդ(for server) */
struct GmcpBuf GMCP_Paccept(int fdx, struct GmcpBuf gbuf)
{
  time_t nowtime=0;
  char tmp[40];
  
  memset(&tmp, 0, sizeof(tmp));
  gbuf = GmcpRBuf(fdx);

  time(&nowtime);

  /* USER¥ꥯȽ */
  if (GMCP_StrCmp(gbuf.rbuf, 4)==0){
    gbuf.flag = P_USER;
    sprintf(tmp, "GMCP/%s\n\0", ctime(&nowtime));
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, tmp), 0);
    if (gbuf.nb<1){
      gbuf.flag = 1;
      close(fdx);
    }
  }
  /* MNTR¥ꥯȽ */
  else if (GMCP_StrCmp(gbuf.rbuf, 5)==0){
    gbuf.flag = P_MNTR;
    sprintf(tmp, "GMCP/%s\n\0", ctime(&nowtime));
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, tmp), 0);
    if (gbuf.nb<1){
      gbuf.flag = 1;
      close(fdx);
    }
  }
  /* ROOT¥ꥯȽ */
  else if (GMCP_StrCmp(gbuf.rbuf, 6)==0){
    gbuf.flag = P_ROOT;
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, GPASS), 0);
    /* ROOTξ̽ʥѥ׵ */
    if (gbuf.nb<1){
      gbuf.flag = 1;
      close(fdx);
    }
  }
  else {
    gbuf.flag = -1;
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, GREJECT), 0);
    close(fdx);
  }  

  return gbuf;
}

/* ¥ꥯ׵(for client) */
/* auth: 0=MNTR, 1=USER, 2=ROOT */
struct GmcpBuf GMCP_Prqst(int fdx, struct GmcpBuf gbuf, int auth, char *ttmp)
{

  if (auth==1){
    gbuf.flag = P_USER;
    gbuf = GmcpSRBuf(fdx, GmcpWriteBuf(gbuf, GUSER), 0);
  }
  else if (auth==2){
    gbuf.flag = P_ROOT;
    gbuf = GmcpSRBuf(fdx, GmcpWriteBuf(gbuf, GROOT), 0);
  }
  else {
    gbuf.flag = P_MNTR;
    gbuf = GmcpSRBuf(fdx, GmcpWriteBuf(gbuf, GMNTR), 0);
  }

  /* ̿顼 */
  if (gbuf.nb<1){
    gbuf.flag = 1;
    close(fdx);
    return gbuf;
  }

  /* REJECT줿 */
  if (GMCP_StrCmp(gbuf.rbuf, 3)==0){
    gbuf.flag = -1;
    close(fdx);
    return gbuf;
  }

  /* ROOTξ̽ */
  if (gbuf.flag==P_ROOT){
    if (GMCP_StrCmp(gbuf.rbuf, 7)!=0){
      gbuf.flag = -2;
    }
    return gbuf;
  }

  if (GMCP_StrCmp(gbuf.rbuf, 0)!=0){
    if (gbuf.flag==P_USER||gbuf.flag==P_MNTR)
      gbuf.flag = -2;   
    else
      gbuf.flag = 1;
  }
  else {
    /* ʬttmp롣ǥߥ"\n" */
    sscanf(gbuf.rbuf, "GMCP/%[^\n]", ttmp);
  }

  return gbuf;
}

/* ѥɤʹ(for server) */
/* psswd: ѥ */
struct GmcpBuf GMCP_PassQ(int fdx, struct GmcpBuf gbuf, char *psswd)
{
  time_t nowtime=0;
  char tmp[40];
  char ptmp[8];

  memset(&tmp, 0, sizeof(tmp));
  memset(&ptmp, 0, sizeof(ptmp));

  /* ѥɤ8ʸ */
  if (strlen(psswd)>8){
    psswd[8]='\0';
  }

  gbuf = GmcpRBuf(fdx);
  /* ̿顼 */
  if (gbuf.nb<1){
    gbuf.flag = 1;
    close(fdx);
    return gbuf;
  }
  else {
    sscanf(gbuf.rbuf, "%s\n", ptmp);
  }

  /* OKʤ, ְ㤤ʤREFUSE֤ */
  if (strncmp(psswd, ptmp, 8)==0) {
    gbuf.flag = P_ROOT;
    sprintf(tmp, "GMCP/%s\n\0", ctime(&nowtime));
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, tmp), 0);
    if (gbuf.nb<1){
      gbuf.flag = 1;
      close(fdx);
    }
  }
  else {
    gbuf.flag = -1;
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, GREFUSE), 0);
    close(fdx);
  }  

  return gbuf;
}

/* ѥɤ(for client) */
/* psswd: ѥ */
struct GmcpBuf GMCP_PassA(int fdx, struct GmcpBuf gbuf, char *psswd, char *ttmp)
{

  /* ѥɤ */
  if (strlen(psswd)>8){
    psswd[8] = '\n';
    strcat(psswd, "\0");
  }
  else {
    strcat(psswd, "\n\0");
  }

  gbuf = GmcpSRBuf(fdx, GmcpWriteBuf(gbuf, psswd), 0);
  /* ̿顼 */
  if (gbuf.nb<1){
    gbuf.flag = 1;
    close(fdx);
    return gbuf;
  }

  /* REFUSE줿 */
  if (GMCP_StrCmp(gbuf.rbuf, 8)==0){
    gbuf.flag = -1;
    close(fdx);
    return gbuf;
  }
  
  if (GMCP_StrCmp(gbuf.rbuf, 0)!=0){
      gbuf.flag = -2;   
  }
  else {
    /* ʬttmp롣ǥߥ"\n" */
    sscanf(gbuf.rbuf, "GMCP/%[^\n]", ttmp);
  }
  
  return gbuf;
}


/* 楳ޥ */

/* ޥɼ */
struct GMCPCom GMCP_RevCOM(int fdx)
{
  int i=0;
  const char mctrc[]="pslgeq\0";
  const int mpara[MNT_NUM]={0,0,0,0,0,0};
  const int mret[MNT_NUM]={5,1,1,1,1,0};
  const char uctrc[]="HLRSTUDVPAJ\0";
  const int upara[USR_NUM]={0,0,0,0,0,0,0,2,4,4,1};
  const int uret[USR_NUM]={1,1,1,1,1,1,1,1,1,1,1};
  const char rctrc[]="EXRQ\0";
  const int rpara[ROOT_NUM]={0,0,0,0};
  const int rret[ROOT_NUM]={0,0,0,0};

  struct GmcpBuf gbuf;
  struct GMCPCom anlycom={0,0,0,0,0};
  
  gbuf = GmcpRBuf(fdx);
  if (gbuf.nb<1){
    anlycom.kind = -2;   /* ̿顼 */
    return anlycom;
  }
  if (strlen(gbuf.rbuf)>5||gbuf.rbuf[3]!='\n'){
    anlycom.kind = -1;   /* ޥ */
    return anlycom;
  }

  /* ޥʸμ */
  /* ޥɤθ */
  /* ˥ޥ */
  if (gbuf.rbuf[0]=='&'){
    anlycom.kind = 0;
    /* ƥޥɤ */
    for (i=0; i<MNT_NUM; i++){
      if (gbuf.rbuf[1]==mctrc[i]){
	anlycom.command = i+1+MNT_START;
	anlycom.para = mpara[i];
	anlycom.ret = mret[i];
	break;
      }
    }    
  } 
  /* 桼ޥ */
  else if (gbuf.rbuf[0]=='#'){
    anlycom.kind = 1;
    /* ƥޥɤ */
    for (i=0; i<USR_NUM; i++){
      if (gbuf.rbuf[1]==uctrc[i]){
	anlycom.command = i+1+USR_START;
	anlycom.para = upara[i];
	anlycom.ret = uret[i];
	break;
      }
    }    
  }
  /* øޥ */
  else if (gbuf.rbuf[0]=='$'){
    anlycom.kind = 2;
    /* ƥޥɤ */
    for (i=0; i<ROOT_NUM; i++){
      if (gbuf.rbuf[1]==rctrc[i]){
	anlycom.command = i+1+ROOT_START;
	anlycom.para = rpara[i];
	anlycom.ret = rret[i];
	break;
      }
    }    
  }
  else {
    anlycom.kind = -1;  /*  */
    return anlycom;
  }

  /* פ륳ޥɤʤä */
  if (anlycom.command==0){
    anlycom.kind = -1;  /*  */
    return anlycom;
  }

  /*  */
  anlycom.axis = (int) gbuf.rbuf[2];

  return anlycom;
}

/* ޥɤθ̤ʬ */
/* comken=-2: ¾ */
struct Gcsl GMCP_AUCOM(int fdx, struct GMCPCom gcom, int comken, 
		       struct ADCPara ADCstate)
{
  int kz=0, ngf=0;
  struct Gcsl ret={0, 0, 0, 0}, param={0, 0, 0, 0};
  struct GmcpBuf gbuf;

  gbuf = GmcpInitBuf(gbuf);

  /* ͭƤ */
  if (comken==-2){
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, "NG\n"), 0);
    ngf = 1;
  }
  /* ꤬ */
  else if ((gcom.kind<0)||(comken<gcom.kind)){
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, "NG\n"), 0);
    ngf = 1;
  }
  else 
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, "OK\n"), 0);

  /* ѥ᡼ˤϤ */
  if (gcom.para>0){
    param = GMCP_PARA(fdx, gcom.para);
    if (param.kz<1){
      ret.kz = -1;
      return ret;
    }
  }

  /* ³ѥ᡼μ */
  if ((kz=GMCP_Kzok(fdx))==-1){
    ret.kz = -1;
    return ret;
  }
  else if ((kz==2)&&(gcom.kind==0)){
    if (ngf==0)
      ret = GMCP_CATCH(fdx, gcom, param, ADCstate);
    else 
      ret.kz = 0;

    return ret;
  }
  else if (ngf==0) {     
    /* ˥ޥ */
    if (gcom.kind==0)
      ret = GMCP_Mcom(fdx, gcom, ADCstate);
    /* 桼ޥ */
    else if (gcom.kind==1)
      ret = GMCP_Ucom(fdx, gcom, param);
    /* øޥ */
    else if (gcom.kind==2)
      ret = GMCP_Rcom(fdx, gcom);
    else {
      ret.kz = kz;
      return ret;
    }

    if ((kz==2)&&(gcom.kind!=0))
      ret.kz = 0;
    else      
      ret.kz = kz;

    return ret;
  }
  else{
    if ((kz==2)&&(gcom.kind!=0))
      ret.kz = 0;
    else      
      ret.kz = kz;

    return ret;
  }
}

/* åܡ⡼ */
struct Gcsl GMCP_CATCH(int fdx, struct GMCPCom gcom, 
		       struct Gcsl param, struct ADCPara ADCstate)
{
  int cpara=0;
  struct Gcsl ret={0, 0, 0, 0};
  struct GmcpBuf gbuf;

  do{
    if (gcom.kind==0)
      ret = GMCP_Mcom(fdx, gcom, ADCstate);
    else if (gcom.kind==1)
      ret = GMCP_Ucom(fdx, gcom, param);
    else if (gcom.kind==2)
      ret = GMCP_Rcom(fdx, gcom);
    else
      return ret;

    gbuf = GmcpInitBuf(gbuf);
    if (gcom.ret==0)
      gbuf = GmcpRBuf(fdx);
    
    else {
      if (gcom.ret==1){
	gbuf.sbuf[0] = ret.c;
	gbuf.sbuf[1] = '\n'; gbuf.sbuf[2] = '\0';
      }
      else if (gcom.ret==2)
	gbuf = shrt2Gbuf(gbuf, ret.s);
      else if (gcom.ret==4)
	gbuf = lng2Gbuf(gbuf, ret.l);
      else if (gcom.ret==5)
	gbuf = five2Gbuf(gbuf, ret);

      gbuf = GmcpSRBuf(fdx, gbuf, gcom.ret+1);
    }

    if (gbuf.nb<1) {
      cpara = 0;
      break;
    }
    
    if (strncmp(gbuf.rbuf, "c\n", 2)==0)
      cpara = 2;
    else if (strncmp(gbuf.rbuf, "b\n", 2)==0)
      cpara = 1;
    else if (strncmp(gbuf.rbuf, "a\n", 2)==0)
      cpara = 0;
    else
      cpara = 0;      
  } while(cpara==2);

  if (cpara==1) ret.kz = 1;
  else ret.kz = 0;

  return ret;
}

/* ѥ᡼ */
struct Gcsl GMCP_PARA(int fdx, int para)
{
  struct Gcsl ret={0, 0, 0, 0};
  struct GmcpBuf gbuf;

  gbuf = GmcpInitBuf(gbuf);
  gbuf = GmcpRBuf(fdx);

  if (gbuf.nb<1) {
    ret.kz=-1;
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, "NG\n"), 0);   
    return ret;
  }

  if (para==1){
    ret.c = gbuf.rbuf[0];
  }
  else if (para==2){
    ret.s = Gbuf2shrt(gbuf);
  }
  else if (para==4){
    ret.l = Gbuf2lng(gbuf);
  }
  else {
    gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, "NG\n"), 0);
    return ret;
  }

  gbuf = GmcpSBuf(fdx, GmcpWriteBuf(gbuf, "OK\n"), 0);
  ret.kz = 1;
  return ret;
}

/* ˥ޥɡQuitʳ */
struct Gcsl GMCP_Mcom(int fdx, struct GMCPCom gcom, struct ADCPara ADCstate)
{
  struct Gcsl ret={0, 0, 0, 0};

  if (gcom.command==GMCP_pos)
    ret = Gctr_GetPos(gcom.axis, ADCstate);
  else if (gcom.command==GMCP_speed)
    ret = Gctr_GetSpeed(gcom.axis);
  else if (gcom.command==GMCP_sense)
    ret = Gctr_GetSense(gcom.axis);
  else if (gcom.command==GMCP_dosa)
    ret = Gctr_GetDosa(gcom.axis);
  else if (gcom.command==GMCP_err)
    ret = Gctr_GetErr(gcom.axis);
  else
    return ret;
  
  return ret;
}

/* 桼ޥ */
struct Gcsl GMCP_Ucom(int fdx, struct GMCPCom gcom, struct Gcsl param)
{
  struct Gcsl ret={0, 0, 0, 0};

  if (gcom.command==GMCP_HOME)
    ret = Gctr_GoHome(gcom.axis);
  else if (gcom.command==GMCP_LCW)
    ret = Gctr_LimitCW(gcom.axis);
  else if (gcom.command==GMCP_LCCW)
    ret = Gctr_LimitCCW(gcom.axis);
  else if (gcom.command==GMCP_STOP)
    ret = Gctr_Stop(gcom.axis);
  else if (gcom.command==GMCP_TESI)
    ret = Gctr_Tesi(gcom.axis);
  else if (gcom.command==GMCP_ON)
    ret = Gctr_ON(gcom.axis);
  else if (gcom.command==GMCP_OFF)
    ret = Gctr_OFF(gcom.axis);
  else if (gcom.command==GMCP_SPEED)
    ret = Gctr_SetSpeed(gcom.axis, param.s);
  else if (gcom.command==GMCP_STEP)
    ret = Gctr_PTPMove(fdx, gcom.axis, param.l);
  else if (gcom.command==GMCP_ABS)
    ret = Gctr_ABSMove(fdx, gcom.axis, param.l);
  else if (gcom.command==GMCP_JOG)
    ret = Gctr_JOGMove(fdx, gcom.axis, param.c);
  else
    return ret;

  return ret;
}

/* øޥ */
struct Gcsl GMCP_Rcom(int fdx, struct GMCPCom gcom)
{
  struct Gcsl ret={0, 0, 0, 0};

  if (gcom.command==GMCP_ESTOP)
    ret = Gctr_AllStop(gcom.axis);
  else
    return ret;

  return ret;
}

/* ³ѥ᡼դ */
/* 0: λ, 1: ³, 2: åܡ, -1: 顼 */
int GMCP_Kzok(int fdx)
{
  struct GmcpBuf gbuf;

  gbuf = GmcpInitBuf(gbuf);
  gbuf = GmcpRBuf(fdx);

  if (gbuf.nb<1) return -1;

  if (strncmp(gbuf.rbuf, "C\n", 2)==0)
    return 2;
  else if (strncmp(gbuf.rbuf, "B\n", 2)==0)
    return 1;
  else if (strncmp(gbuf.rbuf, "A\n", 2)==0)
    return 0;
  else
    return 0;      
}


