#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <machine/cpufunc.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>  /* #include < sys/un.h > */
#include <sys/ipc.h>
#include <termios.h>

#include "sgshot.h"

#include "picoadc_reg.h"
#include "picoadc.h"

#include "gmcpsock.h"
#include "gmcp.h"

#include "gctrcom-sg.h"


#define COUNTER 0   /* default Counter */
#define ONOFF 0   /* defaul ѽ */

#define ODIR 1   /*  - */
#define OTYPE 1  /*  II */


#define ADC_ADR 0x378  /* Pico Tech. ADC */
#define SEM_FREE 1     /* ޥե å */
#define SEM_LOCK (-1)  /* ޥե å */


extern unsigned short SPEEDL;   /* ® */
extern unsigned short SPEEDM;   /* ® */
extern unsigned short SPEEDH;   /* ® */

extern int iofl;


/* ˥ޥ */

/* ּ */
/* ADCstate: ADC */
struct Gcsl Gctr_GetPos(int axis, struct ADCPara ADCstate)
{
  unsigned int adr;
  short cntab=0;
  int adcc=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Status X32s={0,0,0,0,0};
  struct sembuf smbuf[1];

  /* 0-31 counterA, 32-63 counertB */
  /* 64-75 ADC */
  if (axis>63) {
    if (ADCstate.adc==0){
      adcc = 0;
      cntab = 1;
      axis = axis - 64;
    }
    else {
      adcc = 1;
      axis = axis - 64;
    }
  }
  else {
    adcc = 0;
    cntab = 0;
  }

  /* ADCϥơ0 + ֤ͤ */
  if (adcc!=0){
    ret.c = 0;
    /* å */
    smbuf[0].sem_flg = SEM_UNDO;
    smbuf[0].sem_op = SEM_LOCK;
    semop(ADCstate.semid, smbuf, 1);
    
    /* ADCͼ */
    ret.l = (long) ADC_get_value(ADC_ADR, axis, ADCstate.state);
  
    /* å */
    smbuf[0].sem_op = SEM_FREE;
    semop(ADCstate.semid, smbuf, 1);
  
    return ret;
  }

  /* ⡼ȥ */
  X32s=GetStatus();  /* ơ */

  ret.c = 0x00;
  /* ⡼busy */
  if(X32s.DosaStatus!=0)
    ret.c = 0x01;
  else 
    ret.c = 0x00;

  /*  */
  if ((axis==1)&&(X32s.xpos==0)) 
    ret.c = ret.c+0x02;
  else if ((axis==2)&&(X32s.ypos==0)) 
    ret.c = ret.c+0x02;
  else ;

  /* ߥå */
  if (axis==1){
    if ((X32s.StopStatus==1)||(X32s.StopStatus==3)) 
      ret.c = ret.c+0x04;
  }
  else if (axis==2){
    if ((X32s.StopStatus==2)||(X32s.StopStatus==3)) 
      ret.c = ret.c+0x04;
  }
  else ;


  /* 弧 */
  //  if (GetOut(adr, 0)!=0) 
  ret.c = ret.c+0x10;
  //else ;

  /* ߥե饰 */
  if(X32s.DosaStatus!=0)
    ret.c = ret.c+0x20;
  else ;

  /* 顼 */
  if(X32s.ErrStopStatus!=0)
    ret.c = ret.c+0x80;
  else ;
  
  /* ɸͼ */
  if (axis==1){
    ret.l = X32s.xpos;
  }
  else {
    ret.l = X32s.ypos;
  }

  return ret;
}

/* ® */
struct Gcsl Gctr_GetSpeed(int axis)
{
  int spd=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0};

  /* ߤΰưIC */
  Smov=GetMove(axis);

  spd = (int) Smov.speed;

  if (spd<SPEEDL+1) ret.c = 0;  /* ® */
  else if (spd>SPEEDH-1) ret.c = 2;  /* ® */
  else ret.c = 1;  /* ® */

  return ret;
}

/* 󥵡ּ */
struct Gcsl Gctr_GetSense(int axis)
{
  struct Gcsl ret={0,0,0,0};
  struct X32Status X32s={0,0,0,0,0};

  X32s=GetStatus();  /* ơ */

  /* ߥå */
  if (axis==1){
    if ((X32s.StopStatus==1)||(X32s.StopStatus==3)) 
      ret.c = 1;
    else ret.c = 0;
  }
  else if (axis==2){
    if ((X32s.StopStatus==2)||(X32s.StopStatus==3)) 
      ret.c = 1;
    else ret.c = 0;
 }

  return ret;
}

/* ưּ */
struct Gcsl Gctr_GetDosa(int axis)
{
  struct Gcsl ret={0,0,0,0};
  
  if (ChkBusy()==0)
    ret.c = 2;
  else
    ret.c = 1;

  return ret;
}

/* 顼ּ */
struct Gcsl Gctr_GetErr(int axis)
{
  struct Gcsl ret={0,0,0,0};

  ret.c = ChkErr();

  return ret;
}


/* 桼ޥ */

/*  */
struct Gcsl Gctr_GoHome(int axis)
{
  int chk=0;
  struct Gcsl ret={0,0,0,0};

  /* ⡼Υӥå */
  if (ChkBusy()!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = OriginGo(axis);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* CW Limit */
struct Gcsl Gctr_LimitCW(int axis)
{
  int chk=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0};

  /* ⡼Υӥå */
  if (ChkBusy()!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = JogGo(axis, 0);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* CCW Limit */
struct Gcsl Gctr_LimitCCW(int axis)
{
  int chk=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0};

  /* ⡼Υӥå */
  if (ChkBusy()!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = JogGo(axis, 1);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* ̾ */
struct Gcsl Gctr_Stop(int axis)
{
  int st=0;
  struct Gcsl ret={0,0,0,0};

  st = MotorStop(axis, 0);

  if (st==-1) ret.c = -1;
  else ret.c = 0;

  return ret;
}

/* ¨ */
struct Gcsl Gctr_Tesi(int axis)
{
  int st=0;
  struct Gcsl ret={0,0,0,0};

  st = MotorStop(axis, 1);

  if (st==-1) ret.c = -1;
  else ret.c = 0;

  return ret;
}

/* 弧ON */
struct Gcsl Gctr_ON(int axis)
{
  struct Gcsl ret={0,0,0,0};

  if (ChkBusy()!=0) ret.c = 1;
  else OutOnOff(axis, 1);

  return ret;
}

/* 弧OFF */
struct Gcsl Gctr_OFF(int axis)
{
  struct Gcsl ret={0,0,0,0};

  if (ChkBusy()!=0) ret.c = 1;
  else OutOnOff(axis, 0);

  return ret;
}

/* ® */
struct Gcsl Gctr_SetSpeed(int axis, short s)
{
  int chk=0;
  unsigned short spd=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0};

  if (s==2) spd = SPEEDH;       /* ® */
  else if (s==1) spd = SPEEDM;  /* ® */
  else spd = SPEEDL;            /* ® */


  /* ߤΰưIC */
  Smov=GetMove(axis);

  /* ⡼Υӥå */
  if (ChkBusy()!=0) ret.c = 1;
  else {
    /* ®ѹ */
    Smov = SetSpeed(Smov, Smov.stspeed, spd);
    chk = SetMove(axis, Smov);
    
    if (chk>0) ret.c = 0;
    else ret.c = -1;
  }

  return ret;
}

/* PTPư */
struct Gcsl Gctr_PTPMove(int fdx, int axis, long l)
{
  int chk=0;
  unsigned long ul;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0};

  ul = labs(l);
  /* ư̤ */
  if (ul>16777215) {
    ret.c = -1;
    return ret;
  }

  /* ߤΰưIC */
  Smov=GetMove(axis);

  /* ⡼Υӥå */
  if (ChkBusy()!=0) ret.c = 1;
  else {
    /* ǥåư */
    chk = PtpGo(axis, l);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* Ͱư */
struct Gcsl Gctr_ABSMove(int fdx, int axis, long l)
{
  int chk=0;
  struct Gcsl ret={0,0,0,0};

  /* ư̤ */
  if (labs(l)>16777215) {
    ret.c = -1;
    return ret;
  }

  /* ⡼Υӥå */
  if (ChkBusy()!=0) ret.c = 1;
  else {
    /* Ͱư */
    chk = AbsGo(axis, l);
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}

/* 祰ư */
struct Gcsl Gctr_JOGMove(int fdx, int axis, char c)
{
  int chk=0;
  struct Gcsl ret={0,0,0,0};
  struct X32Move Smov={1,1,0};

  /* ߤΰư֤Ϲθʤߡ祰ư */
  chk = MotorStop(axis, 0);
  if (chk<0){
    ret.c = -1;
    return ret;
  }
  else {
    if (c==0)
      chk = JogGo(axis, 0);
    else {
      chk = JogGo(axis, 1);
    }
    if (chk!=0) ret.c = -1;
    else ret.c = 0;
  }

  return ret;
}


/* øޥ */

/* ۵ */
/* ֥⡼ɤǤʤΤ14¨ */
struct Gcsl Gctr_AllStop(int axis)
{
  int i=0;
  struct Gcsl ret={0,0,0,0};

  MotorStop(1, 1);

  return ret;
}

