/* IBX-7208 stepping motor controller board library */
/*             written by Yachan                    */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <machine/cpufunc.h>
#include "sgshot.h"
#include "ctrlcom.h"

#define STOPLOOP 1000

/* Ͱư */
/* adr: μƬɥ쥹 */
/* pos: ɸ */
/* i=0: ®ư, i=other: ®ư */
/* cab: 0=A, 1=B */
int AbsGo(unsigned int adr, long pos, int i, int cab)
{
  int ret=0;
  long oposit=0, opulse=0;
  unsigned long upulse=0;
  struct X32Move Smov={1,1,0,0};

  if (labs(pos)>8388608) {    
    return -1;
  }
  /* ߤΥͤμ */
  oposit=GetCount(adr, cab);
  /* аư */
  opulse = pos-oposit;
  upulse = labs(opulse);

  /* ߤΰưIC */
  Smov=GetMove(adr, 0);
  Smov=SetIdo(Smov, opulse);
  Smov=SetMaxIdo(Smov, upulse);

  ret = PtpGo(adr, Smov, i);

  return ret;
}

/* ǥåư */
/* adr: μƬɥ쥹 */
/* i=0: ®ư, i=other: ®ư */
int PtpGo(unsigned int adr, struct X32Move Smc, int i)
{
  int rt=0;
  
  rt=SetMove(adr, Smc);  /* ư򥻥å */

  if (rt!=0) return rt;  /* ͤʤ꥿ */

  ResetComplete(adr);  /* ưλե饰ꥢ */

  if(i==0){
    if(Smc.dir==0)
      PtpPlus(adr); /* PTPư */
    else
      PtpMinus(adr); /* PTPư */
  }
  else {
    if(Smc.dir==0)
      CPtpPlus(adr); /* ®PTPư*/
    else
      CPtpMinus(adr); /* ®PTPư*/
  }
  
  return 0;
}

/* JOGư */
/* adr: μƬɥ쥹 */
/* i=0: ®ư, i=other: ®ư */
int JogGo(unsigned int adr, struct X32Move Smc, int i)
{
  int rt=0;
  
  rt=SetMove(adr, Smc);  /* ư򥻥å */

  if (rt!=0) return rt;  /* ͤʤ꥿ */

  ResetComplete(adr);  /* ưλե饰ꥢ */

  if(i==0){
    if(Smc.dir==0)
      JogPlus(adr); /* JOGư */
    else
      JogMinus(adr); /* JOGư */
  }
  else {
    if(Smc.dir==0)
      CJogPlus(adr); /* ®JOGư */
    else
      CJogMinus(adr); /* ®JOGư */
  }
  
  return 0;
}

/*  */
/* adr: μƬɥ쥹 */
/* st:0-4  Υ */
int OriginGo(unsigned int adr, char dir, short st)
{
  struct X32Move Smx={0,0,0,0,0};

  Smx=GetMove(adr, dir);  /* ߤΰưѥ᡼μ */
  Smx=SetSpeed(Smx, 10, 50);  /* ®٤٤ */
  SetMove(adr, Smx);

  OriginX(adr, dir, st); /*  */

  return 0;
}

/* ⡼Υӥå */
/* adr: μƬɥ쥹 */
/* return: 0=idle, 1=busy */
int ChkBusy(unsigned int adr)
{
  int bsy=0;
  struct X32Status X32s={0,0,0,0,0,0,0};

  X32s=GetStatus(adr);  /* ơ */

  /* ư֥ơå */
  if((X32s.DosaStatus&0x01)==0){
    bsy=0;  /*  */
  }
  else {
    bsy=1;  /* ư */
  }

  return bsy;
}

/* ø®å */
/* adr: μƬɥ쥹 */
/* return: 0=idle, 1=busy */
int ChkAcc(unsigned int adr)
{
  int acc=0;
  struct X32Status X32s={0,0,0,0,0,0,0};

  X32s=GetStatus(adr);  /* ơ */

  /* ư֥ơå */
  if((X32s.DosaStatus&0x02)!=0){
    acc=1;  /* ® */
  }
  else if((X32s.DosaStatus&0x04)!=0){
    acc=2;  /* ® */
  }
  else {
    acc=0;  /* ® */
  }

  return acc;
}

/* ߥåȥåå */
/* adr: μƬɥ쥹 */
/* return: 0=normal, 1=CW limit, 2=CCW limit */
int ChkLimit(unsigned int adr)
{
  int lmt=0;
  struct X32Status X32s={0,0,0,0,0,0,0};

  X32s=GetStatus(adr);  /* ơ */

  /* 󥵾֥ơå */
  if((X32s.SenserStatus&0x0001)!=0){
    lmt=1;  /* CW limit */
  }
  else if((X32s.SenserStatus&0x0002)!=0){
    lmt=2;  /* CCW limit */
  }
  else {
    lmt=0;  /* normal */
  }

  return lmt;
}

/* 󥵡å */
/* adr: μƬɥ쥹 */
/* return: 0=normal, 1=ORG ON, 2=EZ ON, 3=ORG&EZ ON */
int ChkOrigin(unsigned int adr)
{
  int org=0;
  struct X32Status X32s={0,0,0,0,0,0,0};

  X32s=GetStatus(adr);  /* ơ */

  /* 󥵾֥ơå */
  if((X32s.SenserStatus&0x0100)==0){
    org=0;  /* ORG off */
  }
  else {
    org=1;  /* ORG on */
  }
  if((X32s.SenserStatus&0x0200)==0){
    org=org+0;  /* EZ off */
  }
  else {
    org=org+2;  /* EZ on */
  }

  return org;
}

/* 顼å */
/* adr: μƬɥ쥹 */
/* return: 0=normal, 1=error */
int ChkErr(unsigned int adr)
{
  struct X32Status X32s={0,0,0,0,0,0,0};

  X32s=GetStatus(adr);  /* ơ */

  /* ư֥ơå */
  if((X32s.DosaStatus&0x10)==0){
    return 0;  /*  */
  }
  else {
    return 1;  /* 顼 */
  }
}

/* ̿ */
/* adr: μƬɥ쥹 */
/* i=0: normal,  i=other emergency */
/* return: 0=, -1=ߤʤ, 1=CW limit, 2=CCW limit */
int MotorStop(unsigned int adr, int i)
{
  int x=0, y=0;

  if(i==0) {
    NStop(adr); /* ® */
    while(ChkAcc(adr)!=0){  /* ®Ԥ */
      usleep(2);
    }
  }
  else {
    EStop(adr);  /* ¨ */
  }

  /* ⡼ưå */
  x=0; y=0;
  while((ChkBusy(adr)!=0)&&(y==0)){
    x=x+1;
    if (x>STOPLOOP){
      y=1;
    }
    usleep(2);
  }
  if (y==1) return -1; /* ߤʤ */

  return ChkLimit(adr);  /* ߥåȥåΥå */
}

/* 󥿤Υꥢ */
/* adr: μƬɥ쥹 */
/* a=0:  A, a=other: B */
/* return: ꥢΥ */
long ClearCount(unsigned int adr, short a)
{
  long cnt=0;

  cnt=GetCount(adr, a); /* ͤμ */

  if (a==0)
    ClearCntA(adr);
  else
    ClearCntB(adr);

  return cnt;
}








