%%
%% class file for Linear Accelerator Meeting in Japan, 2004
%%
%% ad-hoc patch by R.Hajima June 21, 2004.
%%

%%
%% This file has been developed as a common template for papers
%% destined for electronic production using Adobe Acrobat
%% software for Accelerator Conferences
%%
%% See the JACo Website for more information
%% 
%%       http://www.cern.ch/accelconf/
%%

%  Special thanks to John Jowett and Michel Goossens from CERN and
%  Martin Comyn at TRIUMF for their significant contributions to 
%  this class file over the period 1996 to 2000.
%                                                 John Poole
%                                                 March 2000


%  JAC2001.cls is a modified version of JAC2000.cls to produce indented
%  first paragraphs after section, subsection and subsubsection headings.
%
%                                                 Martin Comyn  April 2001

\def\fileversion{1.0}
\def\filedate{2004/06/21}
\def\docdate {2004/06/21}

\newlength{\dsep}
\newlength{\dwid}
\newlength{\dht}
\NeedsTeXFormat{pLaTeX2e}
%\ProvidesClass{JAC2003}[\filedate\space Version \fileversion]
\ProvidesClass{LAM2004}[\filedate\space Version \fileversion]
\DeclareOption{acus}
   {\setlength{\dwid}{6mm}%
    \setlength{\dht}{-18mm}
    \setlength{\paperheight}{11in}
    \setlength{\paperwidth}{8.5in}
    \typeout{Setup for US LETTER PAPER}}
\DeclareOption{aca4}
   {\setlength{\dwid}{0mm}%
    \setlength{\dht}{0mm}}
\DeclareOption{boxit}
%%
%%  This option draws a box on the output text with the correct margins
%%
   {\special{!userdict begin /bop-hook{
         gsave
         newpath
         58 55 moveto
         58 737 lineto
         539 737 lineto
         539 55 lineto
         closepath
         stroke
         grestore
         }def end}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

\ExecuteOptions{aca4}
\ProcessOptions

\LoadClass[10pt]{jarticle}
\renewcommand{\normalsize}{\fontsize{10.5pt}{14pt}\selectfont}
\renewcommand{\large}{\fontsize{12.6pt}{16.7pt}\selectfont}
\renewcommand{\Large}{\fontsize{14.7pt}{19.6pt}\selectfont}
\renewcommand{\small}{\fontsize{9.5pt}{12.6pt}\selectfont}
\newcommand{\citesize}{\fontsize{7.5pt}{14pt}\selectfont}

%%
%%  Using Times fonts produces a Uniform, compact document
%%  suitable for the Acrobat Software and printable anywhere.
%%
%%  In a 'modern' TeX installation 
%%  e.g TeXLive Version 3 or later (more information on the JACo Website)
%%  one can use the following command
%%

\renewcommand{\rmdefault}{ptm}

%%
%%  Older installations may require
%%              \RequirePackage{times}
%%
\typeout{------------------------------------------------------------------------}
\typeout{LaTeX2e Class file for Accelerator Conference publication for LaTeX2e users}
\typeout{Use the boxit option to draw a box on page showing the correct margins}
\typeout{Itemize, Enumerate and Description environments are compact versions}
\typeout{ }
\typeout{Do not use this Class file for a paper written in English.}
\typeout{------------------------------------------------------------------------}
\typeout{ }
 
%
% DIMENSION OF TEXT:
 
\setlength{\textheight}{241mm}
\setlength{\textwidth}{170mm}
\setlength{\topmargin}{23mm}
\addtolength{\topmargin}{\dht}
\setlength{\oddsidemargin}{20mm}
\setlength{\evensidemargin}{20mm}
\setlength{\columnsep}{5mm}

 
\hoffset -25.4mm
\voffset -25.4mm
 
\columnseprule 0pt      %    Width of rule between columns.
 
% Use Michel Goossens' dense lists
% Prevent infinite loops

\let\Otemize =\itemize
\let\Onumerate =\enumerate
\let\Oescription =\description
% Zero the vertical spacing parameters
\def\Nospacing{\itemsep=0pt\topsep=0pt\partopsep=0pt\parskip=0pt\parsep=0pt}
% Redefine the environments in terms of the original values
\newenvironment{Itemize}{\Otemize\Nospacing}{\endlist}
\newenvironment{Enumerate}{\Onumerate\Nospacing}{\endlist}
\newenvironment{Description}{\Oescription\Nospacing}{\endlist}

\renewcommand{\topfraction}{.95}
\renewcommand{\bottomfraction}{.95}
\renewcommand{\textfraction}{0.1}
\renewcommand{\floatpagefraction}{0.8}
 
\renewcommand{\baselinestretch}{0.85}

\def\@oddhead{}\def\@evenhead{}
\def\@oddfoot{}
\def\@evenfoot{\@oddfoot}
 
%-----------------------------------------------------------------------
% We acknowledge the borrowing of the clever part of
% Steven Gildea's definition of \section
% from geophysi.sty.
%
% \section is tricky because we want to both support \section* and have
% the section title uppercased.

\def\section{\renewcommand{\thesection}{\@arabic\c@section ~.}%
\secdef\@sectionb\@sections}
\def\@sectionb[#1]#2{\@sections{#2}}
\def\@sections#1{\@startsection {section}{1}{\z@}
                {2.8ex plus 0.8ex minus .1ex}{1.5ex plus .2ex}
                {\large\bf\boldmath}{\uppercase{#1}}}
%                {\large\bf\boldmath\centering}{\uppercase{#1}}}
% Should there be any problem with this, we can revert to the following
% but then the onus is on the user to type the argument of \section in
% uppercase in the input file.
%
%\def\section{\@startsection {section}{1}{\z@}{2.8ex plus 0.8ex minus.1ex}
%                          {1.5ex plus .2ex}{\large\bf\boldmath\centering}}
 
\def\subsection{\renewcommand{\thesection}{\@arabic\c@section}%
\@startsection{subsection}{2}{\z@}{2.0ex plus .4ex minus
   .17ex}{1.2ex plus .17ex}{\normalsize}}
\def\subsubsection{\renewcommand{\thesection}{\@arabic\c@section}%
\@startsection{subsubsection}{3}{\parindent}
 {2.0ex plus .4ex minus .17ex}{-1em}{\normalsize\bf}}
\def\paragraph{\@startsection
     {paragraph}{4}{\z@}{2.0ex plus .4ex minus .17ex}{-1em}{\normalsize\it}}
\def\subparagraph{\@startsection
     {subparagraph}{4}{\parindent}{2.0ex plus .4ex minus
     .17ex}{-1em}{\normalsize\bf}}
 
%\setcounter{secnumdepth}{0}
 
% This definition of \maketitle taken from article.sty, and has been
% somewhat modified.

\def\jtitle#1{\gdef\@jtitle{#1}}
\def\@jtitle{\@latex@error{No \noexpand\jtitle given}\@ehc}

\def\Abstract#1{\gdef\@Abstract{#1}}
\def\@Abstract{\@latex@warning@no@line{No \noexpand\Abstract given}}
 
\def\maketitle{\par
 \begingroup
   \def\thefootnote{\fnsymbol{footnote}}
   \def\@makefnmark{\hbox
       to 5pt{$^{\@thefnmark}$\hss}}
   \twocolumn[\@maketitle]
   \@thanks
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@thanks{}\gdef\@jtitle{}\gdef\@Abstract{}\gdef\@author{}\gdef\@title{}\let\thanks\relax}
 
\newlength{\titleblockheight}       % so user can change it if need be
\setlength{\titleblockheight}{8.5cm}
 
\def\@maketitle{\vbox to \titleblockheight {\hsize\textwidth
  \linewidth\hsize \vskip 3pt {\centering
  {\Large\bf \@title \par}
  \vskip 2em                % Vertical space after title.
  {\normalsize\begin{tabular}[t]{@{}c@{}}\@author \end{tabular}\par}}
  \vskip 1em
  {\normalsize{\it Abstract}\par ~~~~\@Abstract \par}
  \vskip 1em
  {\centering {\Large \@jtitle \par}}
  \vfil}}
  
% The \copyrightspace command is used to produce a blank space in the first
% column where a copyright notice may go.  It works by producing a
% blank footnote of the appropriate size.  Note that it should appear
% after any \footnote commands that produce footnotes for the first
% column.   Adjusted to leave just 1cm.
 
\def\copyrightspace{\footnotetext[0]{\mbox{}\vrule height 1cm width 0pt}}

\def\@cite#1#2{{$^{\mbox{\citesize[{#1\if@tempswa , #2\fi}]}}$}}
 
% Redefine to use smaller fonts
\def\thebibliography#1{\setlength{\itemsep}{0pt}\setlength{\parsep}{0pt}
%  \section*{REFERENCES\@mkboth
%  {REFERENCES}{REFERENCES}}\small\list
%  {\vskip 2em \large \boldmath $B;29MJ88%(B}\small\list
  {\vskip 0.5em \noindent \large \bf $B;29MJ88%(B \par}\small\list
  {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}\leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \usecounter{enumi}}
    \def\newblock{\hskip .11em plus .33em minus .07em}
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax}
 
\let\endthebibliography=\endlist
 
\twocolumn
\sloppy
\parindent 1em
\leftmargini 2em
\leftmargin\leftmargini
\leftmarginv .5em
\leftmarginvi .5em
\flushbottom
%-----------------------------------------------------------------------
